/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.netxms.base.NXCPVariable;

public class NXCPMessage {
    public static final int HEADER_SIZE = 16;
    private int messageCode;
    private long messageId;
    private Map<Long, NXCPVariable> variableMap = new HashMap<Long, NXCPVariable>(0);
    private long timestamp;

    public NXCPMessage(int msgCode) {
        this.messageCode = msgCode;
        this.messageId = 0L;
    }

    public NXCPMessage(int msgCode, long msgId) {
        this.messageCode = msgCode;
        this.messageId = msgId;
    }

    public NXCPMessage(byte[] nxcpMessage) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(nxcpMessage);
        DataInputStream inputStream = new DataInputStream(byteArrayInputStream);
        this.messageCode = inputStream.readUnsignedShort();
        inputStream.skipBytes(6);
        this.messageId = inputStream.readInt();
        int numVars = inputStream.readInt();
        int i = 0;
        while (i < numVars) {
            byteArrayInputStream.mark(byteArrayInputStream.available());
            byte[] df = new byte[16];
            inputStream.readFully(df, 0, 8);
            switch (df[4]) {
                case 3: {
                    break;
                }
                case 0: 
                case 2: 
                case 5: {
                    inputStream.readFully(df, 8, 8);
                    break;
                }
                case 1: 
                case 4: {
                    int size = inputStream.readInt();
                    byteArrayInputStream.reset();
                    df = new byte[size + 12];
                    inputStream.readFully(df);
                    int rem = (size + 12) % 8;
                    if (rem == 0) break;
                    inputStream.skipBytes(8 - rem);
                }
            }
            NXCPVariable variable = new NXCPVariable(df);
            this.variableMap.put(variable.getVariableId(), variable);
            ++i;
        }
    }

    public int getMessageCode() {
        return this.messageCode;
    }

    public void setMessageCode(int msgCode) {
        this.messageCode = msgCode;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(long msgId) {
        this.messageId = msgId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public NXCPVariable findVariable(long varId) {
        return this.variableMap.get(varId);
    }

    public void setVariable(NXCPVariable variable) {
        this.variableMap.put(variable.getVariableId(), variable);
    }

    public void setVariable(long varId, byte[] value) {
        this.setVariable(new NXCPVariable(varId, value));
    }

    public void setVariable(long varId, String value) {
        this.setVariable(new NXCPVariable(varId, value));
    }

    public void setVariable(long varId, Double value) {
        this.setVariable(new NXCPVariable(varId, value));
    }

    public void setVariableInt64(long varId, long value) {
        this.setVariable(new NXCPVariable(varId, 2, value));
    }

    public void setVariableInt32(long varId, int value) {
        this.setVariable(new NXCPVariable(varId, 0, Long.valueOf(value)));
    }

    public void setVariableInt16(long varId, int value) {
        this.setVariable(new NXCPVariable(varId, 3, Long.valueOf(value)));
    }

    public byte[] getVariableAsBinary(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsBinary() : null;
    }

    public String getVariableAsString(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsString() : "";
    }

    public Double getVariableAsReal(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsReal() : 0.0;
    }

    public int getVariableAsInteger(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsInteger().intValue() : 0;
    }

    public long getVariableAsInt64(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsInteger() : 0L;
    }

    public InetAddress getVariableAsInetAddress(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsInetAddress() : null;
    }

    public boolean getVariableAsBoolean(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsInteger() != 0L : false;
    }

    public byte[] createNXCPMessage() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteStream);
        for (NXCPVariable nxcpVariable : this.variableMap.values()) {
            byte[] field = nxcpVariable.createNXCPDataField();
            outputStream.write(field);
        }
        byte[] payload = byteStream.toByteArray();
        byteStream = new ByteArrayOutputStream();
        outputStream = new DataOutputStream(byteStream);
        outputStream.writeShort(this.messageCode);
        outputStream.writeShort(0);
        outputStream.writeInt(payload.length + 16);
        outputStream.writeInt((int)this.messageId);
        outputStream.writeInt(this.variableMap.size());
        outputStream.write(payload);
        return byteStream.toByteArray();
    }
}

