/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public class NXCPVariable {
    public static final int TYPE_INTEGER = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_INT64 = 2;
    public static final int TYPE_INT16 = 3;
    public static final int TYPE_BINARY = 4;
    public static final int TYPE_FLOAT = 5;
    private long variableId;
    private int variableType;
    private Long integerValue;
    private Double realValue;
    private String stringValue;
    private byte[] binaryValue;

    public String toString() {
        StringBuilder result = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        result.append(String.valueOf(this.getClass().getName()) + " Object {" + NEW_LINE);
        result.append(" variableId = " + Long.toString(this.variableId) + NEW_LINE);
        result.append(" variableType = " + this.variableType + NEW_LINE);
        result.append(" integerValue = " + this.integerValue + NEW_LINE);
        result.append(" realValue = " + this.realValue + NEW_LINE);
        result.append(" stringValue = " + this.stringValue + NEW_LINE);
        result.append(" binaryValue = " + Arrays.toString(this.binaryValue) + NEW_LINE);
        result.append("}");
        return result.toString();
    }

    private void setStringValue(String value) {
        this.stringValue = value;
        try {
            this.integerValue = Long.parseLong(this.stringValue);
        }
        catch (NumberFormatException e) {
            this.integerValue = 0L;
        }
        try {
            this.realValue = Double.parseDouble(this.stringValue);
        }
        catch (NumberFormatException e) {
            this.realValue = 0.0;
        }
    }

    public NXCPVariable(long varId, int varType, Long value) {
        this.variableId = varId;
        this.variableType = varType;
        this.integerValue = value;
        this.stringValue = this.integerValue.toString();
        this.realValue = this.integerValue.doubleValue();
    }

    public NXCPVariable(long varId, String value) {
        this.variableId = varId;
        this.variableType = 1;
        this.setStringValue(value);
    }

    public NXCPVariable(long varId, Double value) {
        this.variableId = varId;
        this.variableType = 5;
        this.realValue = value;
        this.stringValue = value.toString();
        this.integerValue = this.realValue.longValue();
    }

    public NXCPVariable(long varId, byte[] value) {
        this.variableId = varId;
        this.variableType = 4;
        this.binaryValue = value;
        this.stringValue = "";
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPVariable(byte[] nxcpDataField) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(nxcpDataField));
        this.variableId = in.readInt();
        this.variableType = in.readUnsignedByte();
        in.skipBytes(1);
        if (this.variableType == 3) {
            this.integerValue = in.readUnsignedShort();
            this.realValue = this.integerValue.doubleValue();
            this.stringValue = this.integerValue.toString();
        } else {
            in.skipBytes(2);
            switch (this.variableType) {
                case 0: {
                    this.integerValue = in.readInt();
                    this.realValue = this.integerValue.doubleValue();
                    this.stringValue = this.integerValue.toString();
                    break;
                }
                case 2: {
                    this.integerValue = in.readLong();
                    this.realValue = this.integerValue.doubleValue();
                    this.stringValue = this.integerValue.toString();
                    break;
                }
                case 5: {
                    this.realValue = in.readDouble();
                    this.integerValue = this.realValue.longValue();
                    this.stringValue = this.realValue.toString();
                    break;
                }
                case 1: {
                    int len = in.readInt() / 2;
                    String str = "";
                    while (len > 0) {
                        str = String.valueOf(str) + in.readChar();
                        --len;
                    }
                    this.setStringValue(str);
                    break;
                }
                case 4: {
                    this.binaryValue = new byte[in.readInt()];
                    in.readFully(this.binaryValue);
                }
            }
        }
    }

    public Long getAsInteger() {
        return this.integerValue;
    }

    public Double getAsReal() {
        return this.realValue;
    }

    public String getAsString() {
        return this.stringValue;
    }

    public byte[] getAsBinary() {
        return this.binaryValue;
    }

    public InetAddress getAsInetAddress() {
        InetAddress inetAddr;
        byte[] addr = new byte[4];
        long intVal = this.integerValue;
        addr[0] = (byte)((intVal & 0xFFFFFFFFFF000000L) >> 24);
        addr[1] = (byte)((intVal & 0xFF0000L) >> 16);
        addr[2] = (byte)((intVal & 0xFF00L) >> 8);
        addr[3] = (byte)(intVal & 0xFFL);
        try {
            inetAddr = InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            inetAddr = null;
        }
        return inetAddr;
    }

    public long getVariableId() {
        return this.variableId;
    }

    public void setVariableId(long variableId) {
        this.variableId = variableId;
    }

    public int getVariableType() {
        return this.variableType;
    }

    private int calculateBinarySize() {
        int size;
        switch (this.variableType) {
            case 0: {
                size = 12;
                break;
            }
            case 2: 
            case 5: {
                size = 16;
                break;
            }
            case 3: {
                size = 8;
                break;
            }
            case 1: {
                size = this.stringValue.length() * 2 + 12;
                break;
            }
            case 4: {
                size = this.binaryValue.length + 12;
                break;
            }
            default: {
                size = 8;
            }
        }
        return size;
    }

    public byte[] createNXCPDataField() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(this.calculateBinarySize());
        DataOutputStream out = new DataOutputStream(byteStream);
        out.writeInt(Long.valueOf(this.variableId).intValue());
        out.writeByte(Long.valueOf(this.variableType).byteValue());
        out.writeByte(0);
        if (this.variableType == 3) {
            out.writeShort(this.integerValue.shortValue());
        } else {
            out.writeShort(0);
            switch (this.variableType) {
                case 0: {
                    out.writeInt(this.integerValue.intValue());
                    break;
                }
                case 2: {
                    out.writeLong(this.integerValue);
                    break;
                }
                case 5: {
                    out.writeDouble(this.realValue);
                    break;
                }
                case 1: {
                    out.writeInt(this.stringValue.length() * 2);
                    out.writeChars(this.stringValue);
                    break;
                }
                case 4: {
                    out.writeInt(this.binaryValue.length);
                    out.write(this.binaryValue);
                }
            }
        }
        int rem = byteStream.size() % 8;
        if (rem != 0) {
            out.write(new byte[8 - rem]);
        }
        return byteStream.toByteArray();
    }
}

