/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCPMessageReceiver;
import org.netxms.base.NXCPMsgWaitQueue;
import org.netxms.client.NXCAlarm;
import org.netxms.client.NXCContainer;
import org.netxms.client.NXCException;
import org.netxms.client.NXCInterface;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCNode;
import org.netxms.client.NXCNotification;
import org.netxms.client.NXCObject;
import org.netxms.client.NXCServerVariable;
import org.netxms.client.NXCSubnet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NXCSession {
    public static final int DEFAULT_CONN_PORT = 4701;
    public static final int CLIENT_PROTOCOL_VERSION = 19;
    public static final int AUTH_TYPE_PASSWORD = 0;
    public static final int AUTH_TYPE_CERTIFICATE = 1;
    public static final int RCC_SUCCESS = 0;
    public static final int RCC_COMPONENT_LOCKED = 1;
    public static final int RCC_ACCESS_DENIED = 2;
    public static final int RCC_INVALID_REQUEST = 3;
    public static final int RCC_TIMEOUT = 4;
    public static final int RCC_OUT_OF_STATE_REQUEST = 5;
    public static final int RCC_DB_FAILURE = 6;
    public static final int RCC_INVALID_OBJECT_ID = 7;
    public static final int RCC_ALREADY_EXIST = 8;
    public static final int RCC_COMM_FAILURE = 9;
    public static final int RCC_SYSTEM_FAILURE = 10;
    public static final int RCC_INVALID_USER_ID = 11;
    public static final int RCC_INVALID_ARGUMENT = 12;
    public static final int RCC_DUPLICATE_DCI = 13;
    public static final int RCC_INVALID_DCI_ID = 14;
    public static final int RCC_OUT_OF_MEMORY = 15;
    public static final int RCC_IO_ERROR = 16;
    public static final int RCC_INCOMPATIBLE_OPERATION = 17;
    public static final int RCC_OBJECT_CREATION_FAILED = 18;
    public static final int RCC_OBJECT_LOOP = 19;
    public static final int RCC_INVALID_OBJECT_NAME = 20;
    public static final int RCC_INVALID_ALARM_ID = 21;
    public static final int RCC_INVALID_ACTION_ID = 22;
    public static final int RCC_OPERATION_IN_PROGRESS = 23;
    public static final int RCC_DCI_COPY_ERRORS = 24;
    public static final int RCC_INVALID_EVENT_CODE = 25;
    public static final int RCC_NO_WOL_INTERFACES = 26;
    public static final int RCC_NO_MAC_ADDRESS = 27;
    public static final int RCC_NOT_IMPLEMENTED = 28;
    public static final int RCC_INVALID_TRAP_ID = 29;
    public static final int RCC_DCI_NOT_SUPPORTED = 30;
    public static final int RCC_VERSION_MISMATCH = 31;
    public static final int RCC_NPI_PARSE_ERROR = 32;
    public static final int RCC_DUPLICATE_PACKAGE = 33;
    public static final int RCC_PACKAGE_FILE_EXIST = 34;
    public static final int RCC_RESOURCE_BUSY = 35;
    public static final int RCC_INVALID_PACKAGE_ID = 36;
    public static final int RCC_INVALID_IP_ADDR = 37;
    public static final int RCC_ACTION_IN_USE = 38;
    public static final int RCC_VARIABLE_NOT_FOUND = 39;
    public static final int RCC_BAD_PROTOCOL = 40;
    public static final int RCC_ADDRESS_IN_USE = 41;
    public static final int RCC_NO_CIPHERS = 42;
    public static final int RCC_INVALID_PUBLIC_KEY = 43;
    public static final int RCC_INVALID_SESSION_KEY = 44;
    public static final int RCC_NO_ENCRYPTION_SUPPORT = 45;
    public static final int RCC_INTERNAL_ERROR = 46;
    public static final int RCC_EXEC_FAILED = 47;
    public static final int RCC_INVALID_TOOL_ID = 48;
    public static final int RCC_SNMP_ERROR = 49;
    public static final int RCC_BAD_REGEXP = 50;
    public static final int RCC_UNKNOWN_PARAMETER = 51;
    public static final int RCC_FILE_IO_ERROR = 52;
    public static final int RCC_CORRUPTED_MIB_FILE = 53;
    public static final int RCC_TRANSFER_IN_PROGRESS = 54;
    public static final int RCC_INVALID_LPP_ID = 55;
    public static final int RCC_INVALID_SCRIPT_ID = 56;
    public static final int RCC_INVALID_SCRIPT_NAME = 57;
    public static final int RCC_UNKNOWN_MAP_NAME = 58;
    public static final int RCC_INVALID_MAP_ID = 59;
    public static final int RCC_ACCOUNT_DISABLED = 60;
    public static final int RCC_NO_GRACE_LOGINS = 61;
    public static final int RCC_CONNECTION_BROKEN = 62;
    public static final int RCC_INVALID_CONFIG_ID = 63;
    public static final int RCC_DB_CONNECTION_LOST = 64;
    public static final int RCC_ALARM_OPEN_IN_HELPDESK = 65;
    public static final int RCC_ALARM_NOT_OUTSTANDING = 66;
    public static final int RCC_NOT_PUSH_DCI = 67;
    public static final int RCC_NXMP_PARSE_ERROR = 68;
    public static final int RCC_NXMP_VALIDATION_ERROR = 69;
    public static final int RCC_INVALID_GRAPH_ID = 70;
    public static final int RCC_LOCAL_CRYPTO_ERROR = 71;
    public static final int RCC_UNSUPPORTED_AUTH_TYPE = 72;
    public static final int RCC_BAD_CERTIFICATE = 73;
    public static final int RCC_INVALID_CERT_ID = 74;
    public static final int RCC_SNMP_FAILURE = 75;
    public static final int RCC_NO_L2_TOPOLOGY_SUPPORT = 76;
    public static final int RCC_INVALID_SITUATION_ID = 77;
    public static final int RCC_INSTANCE_NOT_FOUND = 78;
    public static final int RCC_INVALID_EVENT_ID = 79;
    public static final int RCC_AGENT_ERROR = 80;
    public static final int RCC_UNKNOWN_VARIABLE = 81;
    public static final int RCC_RESOURCE_NOT_AVAILABLE = 82;
    private static final int CLIENT_CHALLENGE_SIZE = 256;
    private final Semaphore syncObjects = new Semaphore(1);
    private String connAddress;
    private int connPort;
    private String connLoginName;
    private String connPassword;
    private boolean connUseEncryption;
    private String connClientInfo = "nxjclient/0.2.23-rc4";
    private int userId;
    private int userSystemRights;
    private Socket connSocket = null;
    private NXCPMsgWaitQueue msgWaitQueue = null;
    private ReceiverThread recvThread = null;
    private long requestId = 0L;
    private boolean isConnected = false;
    private int recvBufferSize = 0x400000;
    private int commandTimeout = 30000;
    private HashSet<NXCListener> listeners = new HashSet(0);
    private String serverVersion = "(unknown)";
    private byte[] serverId = new byte[8];
    private String serverTimeZone;
    private byte[] serverChallenge = new byte[256];
    private Map<Long, NXCObject> objectList = new HashMap<Long, NXCObject>();

    private static NXCObject createObjectFromMessage(NXCPMessage msg) {
        NXCObject object;
        int objectClass = msg.getVariableAsInteger(5L);
        switch (objectClass) {
            case 3: {
                object = new NXCInterface(msg);
                break;
            }
            case 1: {
                object = new NXCSubnet(msg);
                break;
            }
            case 5: {
                object = new NXCContainer(msg);
                break;
            }
            case 2: {
                object = new NXCNode(msg);
                break;
            }
            default: {
                object = new NXCObject(msg);
            }
        }
        return object;
    }

    public NXCSession(String connAddress, String connLoginName, String connPassword) {
        this.connAddress = connAddress;
        this.connPort = 4701;
        this.connLoginName = connLoginName;
        this.connPassword = connPassword;
        this.connUseEncryption = false;
    }

    public NXCSession(String connAddress, int connPort, String connLoginName, String connPassword) {
        this.connAddress = connAddress;
        this.connPort = connPort;
        this.connLoginName = connLoginName;
        this.connPassword = connPassword;
        this.connUseEncryption = false;
    }

    public NXCSession(String connAddress, int connPort, String connLoginName, String connPassword, boolean connUseEncryption) {
        this.connAddress = connAddress;
        this.connPort = connPort;
        this.connLoginName = connLoginName;
        this.connPassword = connPassword;
        this.connUseEncryption = connUseEncryption;
    }

    protected void finalize() {
        this.disconnect();
    }

    private void waitForSync(Semaphore syncObject, int timeout) throws NXCException {
        if (timeout == 0) {
            syncObject.acquireUninterruptibly();
        } else {
            long actualTimeout = timeout;
            boolean success = false;
            while (actualTimeout > 0L) {
                long startTime = System.currentTimeMillis();
                try {
                    if (this.syncObjects.tryAcquire(actualTimeout, TimeUnit.MILLISECONDS)) {
                        success = true;
                        this.syncObjects.release();
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                actualTimeout -= System.currentTimeMillis() - startTime;
            }
            if (!success) {
                throw new NXCException(4);
            }
        }
    }

    private void completeSync(Semaphore syncObject) {
        syncObject.release();
    }

    public void addListener(NXCListener lst) {
        this.listeners.add(lst);
    }

    public void removeListener(NXCListener lst) {
        this.listeners.remove(lst);
    }

    protected synchronized void sendNotification(NXCNotification n) {
        Iterator<NXCListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().notificationHandler(n);
        }
    }

    private synchronized void sendMessage(NXCPMessage msg) throws IOException {
        this.connSocket.getOutputStream().write(msg.createNXCPMessage());
    }

    private NXCPMessage waitForMessage(int code, long id) throws NXCException {
        NXCPMessage msg = this.msgWaitQueue.waitForMessage(code, id);
        if (msg == null) {
            throw new NXCException(4);
        }
        return msg;
    }

    private void waitForRCC(long id) throws NXCException {
        NXCPMessage msg = this.waitForMessage(29, id);
        int rcc = msg.getVariableAsInteger(28L);
        if (rcc != 0) {
            throw new NXCException(rcc);
        }
    }

    private final NXCPMessage newMessage(int code) {
        return new NXCPMessage(code, this.requestId++);
    }

    public void connect() throws IOException, UnknownHostException, NXCException {
        try {
            this.connSocket = new Socket(this.connAddress, this.connPort);
            this.msgWaitQueue = new NXCPMsgWaitQueue(this.commandTimeout);
            this.recvThread = new ReceiverThread();
            NXCPMessage request = this.newMessage(103);
            this.sendMessage(request);
            NXCPMessage response = this.waitForMessage(29, request.getMessageId());
            if (response.getVariableAsInteger(146L) != 19) {
                throw new NXCException(40);
            }
            this.serverVersion = response.getVariableAsString(121L);
            this.serverId = response.getVariableAsBinary(142L);
            this.serverTimeZone = response.getVariableAsString(308L);
            this.serverChallenge = response.getVariableAsBinary(278L);
            request = this.newMessage(1);
            request.setVariable(1L, this.connLoginName);
            request.setVariable(2L, this.connPassword);
            request.setVariableInt16(275L, 0);
            request.setVariable(177L, "0.2.23-rc4");
            request.setVariable(175L, this.connClientInfo);
            request.setVariable(176L, String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version"));
            this.sendMessage(request);
            response = this.waitForMessage(2, request.getMessageId());
            int rcc = response.getVariableAsInteger(28L);
            if (rcc != 0) {
                throw new NXCException(rcc);
            }
            this.userId = response.getVariableAsInteger(35L);
            this.userSystemRights = response.getVariableAsInteger(36L);
            this.isConnected = true;
        }
        finally {
            if (!this.isConnected) {
                this.disconnect();
            }
        }
    }

    public void disconnect() {
        if (this.connSocket != null) {
            try {
                this.connSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.recvThread != null) {
            while (this.recvThread.isAlive()) {
                try {
                    this.recvThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.recvThread = null;
        }
        this.connSocket = null;
        if (this.msgWaitQueue != null) {
            this.msgWaitQueue.shutdown();
            this.msgWaitQueue = null;
        }
        this.isConnected = false;
    }

    public int getRecvBufferSize() {
        return this.recvBufferSize;
    }

    public void setRecvBufferSize(int recvBufferSize) {
        this.recvBufferSize = recvBufferSize;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public byte[] getServerId() {
        return this.serverId;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public byte[] getServerChallenge() {
        return this.serverChallenge;
    }

    public String getConnClientInfo() {
        return this.connClientInfo;
    }

    public void setConnClientInfo(String connClientInfo) {
        this.connClientInfo = connClientInfo;
    }

    public void setCommandTimeout(int commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getUserSystemRights() {
        return this.userSystemRights;
    }

    public synchronized void syncObjects() throws IOException, NXCException {
        this.syncObjects.acquireUninterruptibly();
        NXCPMessage msg = this.newMessage(5);
        msg.setVariableInt16(254L, 1);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.waitForSync(this.syncObjects, this.commandTimeout * 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NXCObject findObjectById(long id) {
        NXCObject obj;
        Map<Long, NXCObject> map = this.objectList;
        synchronized (map) {
            obj = this.objectList.get(id);
        }
        return obj;
    }

    public NXCObject[] getTopLevelObjects() {
        HashSet<NXCObject> list = new HashSet<NXCObject>();
        list.add(this.findObjectById(1L));
        list.add(this.findObjectById(2L));
        list.add(this.findObjectById(3L));
        return list.toArray(new NXCObject[list.size()]);
    }

    public HashMap<Long, NXCAlarm> getAlarms(boolean getTerminated) throws IOException, NXCException {
        long alarmId;
        NXCPMessage msg = this.newMessage(70);
        long rqId = msg.getMessageId();
        msg.setVariableInt16(96L, getTerminated ? 1 : 0);
        this.sendMessage(msg);
        HashMap<Long, NXCAlarm> alarmList = new HashMap<Long, NXCAlarm>(0);
        while ((alarmId = (long)(msg = this.waitForMessage(74, rqId)).getVariableAsInteger(93L)) != 0L) {
            alarmList.put(alarmId, new NXCAlarm(msg));
        }
        return alarmList;
    }

    public void acknowledgeAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(72);
        msg.setVariableInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void terminateAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(181);
        msg.setVariableInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(75);
        msg.setVariableInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void openAlarm(long alarmId, String reference) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(4);
        msg.setVariableInt32(93L, (int)alarmId);
        msg.setVariableInt16(246L, 1);
        msg.setVariable(247L, reference);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void closeAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(4);
        msg.setVariableInt32(93L, (int)alarmId);
        msg.setVariableInt16(246L, 2);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public HashMap<String, NXCServerVariable> getServerVariables() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(13);
        this.sendMessage(msg);
        msg = this.waitForMessage(29, msg.getMessageId());
        int rcc = msg.getVariableAsInteger(28L);
        if (rcc != 0) {
            throw new NXCException(rcc);
        }
        int count = msg.getVariableAsInteger(144L);
        HashMap<String, NXCServerVariable> varList = new HashMap<String, NXCServerVariable>(count);
        int i = 0;
        long id = 0x10000000L;
        while (i < count) {
            String name = msg.getVariableAsString(id);
            varList.put(name, new NXCServerVariable(name, msg.getVariableAsString(id + 1L), msg.getVariableAsBoolean(id + 2L)));
            ++i;
            id += 3L;
        }
        return varList;
    }

    public void setServerVariable(String name, String value) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(14);
        msg.setVariable(20L, name);
        msg.setVariable(21L, value);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteServerVariable(String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(17);
        msg.setVariable(20L, name);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    static /* synthetic */ int access$0(NXCSession nXCSession) {
        return nXCSession.recvBufferSize;
    }

    static /* synthetic */ Socket access$1(NXCSession nXCSession) {
        return nXCSession.connSocket;
    }

    static /* synthetic */ NXCObject access$2(NXCPMessage nXCPMessage) {
        return NXCSession.createObjectFromMessage(nXCPMessage);
    }

    static /* synthetic */ Map access$3(NXCSession nXCSession) {
        return nXCSession.objectList;
    }

    static /* synthetic */ Semaphore access$4(NXCSession nXCSession) {
        return nXCSession.syncObjects;
    }

    static /* synthetic */ void access$5(NXCSession nXCSession, Semaphore semaphore) {
        nXCSession.completeSync(semaphore);
    }

    static /* synthetic */ NXCPMsgWaitQueue access$6(NXCSession nXCSession) {
        return nXCSession.msgWaitQueue;
    }

    private class ReceiverThread
    extends Thread {
        ReceiverThread() {
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            receiver = new NXCPMessageReceiver(NXCSession.access$0(NXCSession.this));
            try {
                in = NXCSession.access$1(NXCSession.this).getInputStream();
                if (true) ** GOTO lbl38
            }
            catch (IOException e) {
                return;
            }
            block13: do {
                try {
                    msg = receiver.receiveMessage(in);
                    switch (msg.getMessageCode()) {
                        case 6: 
                        case 10: {
                            obj = NXCSession.access$2(msg);
                            var5_8 = NXCSession.access$3(NXCSession.this);
                            synchronized (var5_8) {
                                NXCSession.access$3(NXCSession.this).put(obj.getObjectId(), obj);
                            }
                            if (msg.getMessageCode() != 10) continue block13;
                            NXCSession.this.sendNotification(new NXCNotification(4, obj));
                            break;
                        }
                        case 9: {
                            NXCSession.access$5(NXCSession.this, NXCSession.access$4(NXCSession.this));
                            break;
                        }
                        case 73: {
                            NXCSession.this.sendNotification(new NXCNotification(msg.getVariableAsInteger(23L) + 1000, new NXCAlarm(msg)));
                            break;
                        }
                        default: {
                            NXCSession.access$6(NXCSession.this).putMessage(msg);
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    break;
                }
                catch (NXCPException var3_6) {
                    // empty catch block
                }
lbl38:
                // 4 sources

            } while (NXCSession.access$1(NXCSession.this).isConnected());
        }
    }
}

