/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netxms.client.NXCMapObjectData;
import org.netxms.client.NXCMapObjectLink;
import org.netxms.client.NXCObject;
import org.netxms.client.NXCSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NXCMapPage {
    private String name;
    private Set<NXCMapObjectData> objects = new HashSet<NXCMapObjectData>(0);
    private Set<NXCMapObjectLink> links = new HashSet<NXCMapObjectLink>(0);

    public NXCMapPage() {
        this.name = "";
    }

    public NXCMapPage(String name) {
        this.name = name;
    }

    public void addObject(NXCMapObjectData object) {
        this.objects.add(object);
    }

    public void addLink(NXCMapObjectLink link) {
        this.links.add(link);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<NXCMapObjectData> getObjects() {
        return this.objects;
    }

    public Set<NXCMapObjectLink> getLinks() {
        return this.links;
    }

    public Object[] getObjectsAndLinks(NXCSession session) {
        Object[] list = new Object[this.objects.size() + this.links.size()];
        Iterator<NXCMapObjectData> oit = this.objects.iterator();
        int i = 0;
        while (oit.hasNext()) {
            NXCMapObjectData data = oit.next();
            long id = data.getObjectId();
            list[i] = session.findObjectById(id);
            ++i;
        }
        Iterator<NXCMapObjectLink> lit = this.links.iterator();
        int i2 = this.objects.size();
        while (lit.hasNext()) {
            list[i2] = lit.next();
            ++i2;
        }
        return list;
    }

    public NXCObject[] getResolvedObjects(NXCSession session) {
        NXCObject[] list = new NXCObject[this.objects.size()];
        Iterator<NXCMapObjectData> it = this.objects.iterator();
        int i = 0;
        while (it.hasNext()) {
            NXCMapObjectData data = it.next();
            long id = data.getObjectId();
            list[i] = session.findObjectById(id);
            ++i;
        }
        return list;
    }

    public NXCObject[] getConnectedObjects(long root, NXCSession session) {
        HashSet<NXCObject> result = new HashSet<NXCObject>(0);
        for (NXCMapObjectLink link : this.links) {
            NXCObject object;
            long id;
            if (link.getObject1() == root) {
                id = link.getObject2();
                object = session.findObjectById(id);
                if (object == null) continue;
                result.add(object);
                continue;
            }
            if (link.getObject1() != root || (object = session.findObjectById(id = link.getObject1())) == null) continue;
            result.add(object);
        }
        return result.toArray(new NXCObject[result.size()]);
    }
}

