/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCAccessListElement;
import org.netxms.client.NXCSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NXCObject {
    public static final int OBJECT_GENERIC = 0;
    public static final int OBJECT_SUBNET = 1;
    public static final int OBJECT_NODE = 2;
    public static final int OBJECT_INTERFACE = 3;
    public static final int OBJECT_NETWORK = 4;
    public static final int OBJECT_CONTAINER = 5;
    public static final int OBJECT_ZONE = 6;
    public static final int OBJECT_SERVICEROOT = 7;
    public static final int OBJECT_TEMPLATE = 8;
    public static final int OBJECT_TEMPLATEGROUP = 9;
    public static final int OBJECT_TEMPLATEROOT = 10;
    public static final int OBJECT_NETWORKSERVICE = 11;
    public static final int OBJECT_VPNCONNECTOR = 12;
    public static final int OBJECT_CONDITION = 13;
    public static final int OBJECT_CLUSTER = 14;
    public static final int STATUS_NORMAL = 0;
    public static final int STATUS_WARNING = 1;
    public static final int STATUS_MINOR = 2;
    public static final int STATUS_MAJOR = 3;
    public static final int STATUS_CRITICAL = 4;
    public static final int STATUS_UNKNOWN = 5;
    public static final int STATUS_UNMANAGED = 6;
    public static final int STATUS_DISABLED = 7;
    public static final int STATUS_TESTING = 8;
    private NXCSession session = null;
    private long objectId = 0L;
    private String objectName;
    private int objectClass;
    private int status = 5;
    private boolean isDeleted = false;
    private InetAddress primaryIP;
    private String comments;
    private HashSet<Long> parents = new HashSet(0);
    private HashSet<Long> childs = new HashSet(0);
    private Map<String, String> customAttributes = new HashMap<String, String>(0);
    private boolean inheritAccessRights = true;
    private HashSet<NXCAccessListElement> accessList = new HashSet(0);

    NXCObject(NXCPMessage msg, NXCSession session) {
        this.session = session;
        this.objectId = msg.getVariableAsInteger(3L);
        this.objectName = msg.getVariableAsString(4L);
        this.objectClass = msg.getVariableAsInteger(5L);
        this.primaryIP = msg.getVariableAsInetAddress(8L);
        this.isDeleted = msg.getVariableAsBoolean(30L);
        int count = msg.getVariableAsInteger(7L);
        int i = 0;
        long id = 12288L;
        while (i < count) {
            this.parents.add(msg.getVariableAsInt64(id));
            ++i;
            ++id;
        }
        count = msg.getVariableAsInteger(31L);
        i = 0;
        id = 0x80000000L;
        while (i < count) {
            this.childs.add(msg.getVariableAsInt64(id));
            ++i;
            ++id;
        }
        count = msg.getVariableAsInteger(309L);
        i = 0;
        id = 0x70000000L;
        while (i < count) {
            this.customAttributes.put(msg.getVariableAsString(id), msg.getVariableAsString(id + 1L));
            ++i;
            id += 2L;
        }
        this.inheritAccessRights = msg.getVariableAsBoolean(33L);
        count = msg.getVariableAsInteger(32L);
        i = 0;
        id = 4096L;
        long id2 = 8192L;
        while (i < count) {
            this.accessList.add(new NXCAccessListElement(msg.getVariableAsInteger(id), msg.getVariableAsInteger(id2)));
            ++i;
            ++id;
            ++id2;
        }
    }

    public Iterator<Long> getParents() {
        return this.parents.iterator();
    }

    public Iterator<Long> getChilds() {
        return this.childs.iterator();
    }

    public Iterator<NXCAccessListElement> getAccessList() {
        return this.accessList.iterator();
    }

    public String getComments() {
        return this.comments;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public InetAddress getPrimaryIP() {
        return this.primaryIP;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isInheritAccessRights() {
        return this.inheritAccessRights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParent(long objectId) {
        boolean rc = false;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            Iterator<Long> it = this.parents.iterator();
            int i = 0;
            while (it.hasNext()) {
                long id = it.next();
                if (id == objectId) {
                    rc = true;
                    break;
                }
                NXCObject object = this.session.findObjectById(id);
                if (object != null && object.isParent(objectId)) {
                    rc = true;
                    break;
                }
                ++i;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NXCObject[] getParentsAsArray() {
        NXCObject[] list;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            list = new NXCObject[this.parents.size()];
            Iterator<Long> it = this.parents.iterator();
            int i = 0;
            while (it.hasNext()) {
                list[i] = this.session.findObjectById(it.next());
                ++i;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NXCObject[] getChildsAsArray() {
        NXCObject[] list;
        HashSet<Long> hashSet = this.childs;
        synchronized (hashSet) {
            list = new NXCObject[this.childs.size()];
            Iterator<Long> it = this.childs.iterator();
            int i = 0;
            while (it.hasNext()) {
                list[i] = this.session.findObjectById(it.next());
                ++i;
            }
        }
        return list;
    }

    public int getNumberOfParents() {
        return this.parents.size();
    }

    public int getNumberOfChilds() {
        return this.childs.size();
    }

    public int getObjectClass() {
        return this.objectClass;
    }

    public String getObjectClassName() {
        return "Class " + Integer.toString(this.objectClass);
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }
}

