/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netxms.base.NXCPMessage;

public class NXCPMsgWaitQueue {
    private Map<Long, NXCPMessage> messageList = new HashMap<Long, NXCPMessage>(0);
    private int defaultTimeout;
    private int messageLifeTime;
    private boolean isActive = true;
    private HousekeeperThread housekeeperThread = null;

    public NXCPMsgWaitQueue(int defaultTimeout, int messageLifeTime) {
        this.defaultTimeout = defaultTimeout;
        this.messageLifeTime = messageLifeTime;
        this.housekeeperThread = new HousekeeperThread();
    }

    public NXCPMsgWaitQueue(int defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
        this.messageLifeTime = 60000;
        this.housekeeperThread = new HousekeeperThread();
    }

    protected void finalize() {
        this.shutdown();
    }

    private Long calculateMessageHash(NXCPMessage msg) {
        return ((long)msg.getMessageCode() << 32) + msg.getMessageId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMessage(NXCPMessage msg) {
        Map<Long, NXCPMessage> map = this.messageList;
        synchronized (map) {
            msg.setTimestamp(System.currentTimeMillis());
            this.messageList.put(this.calculateMessageHash(msg), msg);
            this.messageList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NXCPMessage waitForMessage(int code, long id, int timeout) {
        Long hash = ((long)code << 32) + id;
        NXCPMessage msg = null;
        int actualTimeout = timeout;
        while (actualTimeout > 0) {
            Map<Long, NXCPMessage> map = this.messageList;
            synchronized (map) {
                msg = this.messageList.get(hash);
                if (msg != null && msg.getMessageCode() == code && msg.getMessageId() == id) {
                    this.messageList.remove(hash);
                    break;
                }
                msg = null;
                long startTime = System.currentTimeMillis();
                try {
                    this.messageList.wait(actualTimeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                actualTimeout = (int)((long)actualTimeout - (System.currentTimeMillis() - startTime));
            }
        }
        return msg;
    }

    public NXCPMessage waitForMessage(int code, long id) {
        return this.waitForMessage(code, id, this.defaultTimeout);
    }

    public void shutdown() {
        this.isActive = false;
        if (this.housekeeperThread != null) {
            while (this.housekeeperThread.isAlive()) {
                try {
                    this.housekeeperThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.housekeeperThread = null;
        }
    }

    private class HousekeeperThread
    extends Thread {
        HousekeeperThread() {
            super("NXCPMsgWaitQueue::HousekeeperThread");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (NXCPMsgWaitQueue.this.isActive) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Map map = NXCPMsgWaitQueue.this.messageList;
                synchronized (map) {
                    long currTime = System.currentTimeMillis();
                    Iterator it = NXCPMsgWaitQueue.this.messageList.values().iterator();
                    while (it.hasNext()) {
                        NXCPMessage msg = (NXCPMessage)it.next();
                        if (msg.getTimestamp() + (long)NXCPMsgWaitQueue.this.messageLifeTime >= currTime) continue;
                        it.remove();
                    }
                }
            }
        }
    }
}

