/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.netxms.base.NXCPDataInputStream;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCPMessageReceiver;
import org.netxms.base.NXCPMsgWaitQueue;
import org.netxms.client.NXCAccessListElement;
import org.netxms.client.NXCAgentPolicy;
import org.netxms.client.NXCAgentPolicyConfig;
import org.netxms.client.NXCAlarm;
import org.netxms.client.NXCContainer;
import org.netxms.client.NXCDCIData;
import org.netxms.client.NXCDCIDataRow;
import org.netxms.client.NXCDCIValue;
import org.netxms.client.NXCEntireNetwork;
import org.netxms.client.NXCException;
import org.netxms.client.NXCInterface;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCMapObjectData;
import org.netxms.client.NXCMapObjectLink;
import org.netxms.client.NXCMapPage;
import org.netxms.client.NXCNode;
import org.netxms.client.NXCNotification;
import org.netxms.client.NXCObject;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCPolicyGroup;
import org.netxms.client.NXCPolicyRoot;
import org.netxms.client.NXCReceivedFile;
import org.netxms.client.NXCServerJob;
import org.netxms.client.NXCServerVariable;
import org.netxms.client.NXCServiceRoot;
import org.netxms.client.NXCSubnet;
import org.netxms.client.NXCTemplate;
import org.netxms.client.NXCUser;
import org.netxms.client.NXCUserDBObject;
import org.netxms.client.NXCUserGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NXCSession {
    public static final int DEFAULT_CONN_PORT = 4701;
    public static final int CLIENT_PROTOCOL_VERSION = 21;
    public static final int AUTH_TYPE_PASSWORD = 0;
    public static final int AUTH_TYPE_CERTIFICATE = 1;
    public static final int CHANNEL_EVENTS = 1;
    public static final int CHANNEL_SYSLOG = 2;
    public static final int CHANNEL_ALARMS = 4;
    public static final int CHANNEL_OBJECTS = 8;
    public static final int CHANNEL_SNMP_TRAPS = 16;
    public static final int CHANNEL_AUDIT_LOG = 32;
    public static final int CHANNEL_SITUATIONS = 64;
    public static final int RCC_SUCCESS = 0;
    public static final int RCC_COMPONENT_LOCKED = 1;
    public static final int RCC_ACCESS_DENIED = 2;
    public static final int RCC_INVALID_REQUEST = 3;
    public static final int RCC_TIMEOUT = 4;
    public static final int RCC_OUT_OF_STATE_REQUEST = 5;
    public static final int RCC_DB_FAILURE = 6;
    public static final int RCC_INVALID_OBJECT_ID = 7;
    public static final int RCC_ALREADY_EXIST = 8;
    public static final int RCC_COMM_FAILURE = 9;
    public static final int RCC_SYSTEM_FAILURE = 10;
    public static final int RCC_INVALID_USER_ID = 11;
    public static final int RCC_INVALID_ARGUMENT = 12;
    public static final int RCC_DUPLICATE_DCI = 13;
    public static final int RCC_INVALID_DCI_ID = 14;
    public static final int RCC_OUT_OF_MEMORY = 15;
    public static final int RCC_IO_ERROR = 16;
    public static final int RCC_INCOMPATIBLE_OPERATION = 17;
    public static final int RCC_OBJECT_CREATION_FAILED = 18;
    public static final int RCC_OBJECT_LOOP = 19;
    public static final int RCC_INVALID_OBJECT_NAME = 20;
    public static final int RCC_INVALID_ALARM_ID = 21;
    public static final int RCC_INVALID_ACTION_ID = 22;
    public static final int RCC_OPERATION_IN_PROGRESS = 23;
    public static final int RCC_DCI_COPY_ERRORS = 24;
    public static final int RCC_INVALID_EVENT_CODE = 25;
    public static final int RCC_NO_WOL_INTERFACES = 26;
    public static final int RCC_NO_MAC_ADDRESS = 27;
    public static final int RCC_NOT_IMPLEMENTED = 28;
    public static final int RCC_INVALID_TRAP_ID = 29;
    public static final int RCC_DCI_NOT_SUPPORTED = 30;
    public static final int RCC_VERSION_MISMATCH = 31;
    public static final int RCC_NPI_PARSE_ERROR = 32;
    public static final int RCC_DUPLICATE_PACKAGE = 33;
    public static final int RCC_PACKAGE_FILE_EXIST = 34;
    public static final int RCC_RESOURCE_BUSY = 35;
    public static final int RCC_INVALID_PACKAGE_ID = 36;
    public static final int RCC_INVALID_IP_ADDR = 37;
    public static final int RCC_ACTION_IN_USE = 38;
    public static final int RCC_VARIABLE_NOT_FOUND = 39;
    public static final int RCC_BAD_PROTOCOL = 40;
    public static final int RCC_ADDRESS_IN_USE = 41;
    public static final int RCC_NO_CIPHERS = 42;
    public static final int RCC_INVALID_PUBLIC_KEY = 43;
    public static final int RCC_INVALID_SESSION_KEY = 44;
    public static final int RCC_NO_ENCRYPTION_SUPPORT = 45;
    public static final int RCC_INTERNAL_ERROR = 46;
    public static final int RCC_EXEC_FAILED = 47;
    public static final int RCC_INVALID_TOOL_ID = 48;
    public static final int RCC_SNMP_ERROR = 49;
    public static final int RCC_BAD_REGEXP = 50;
    public static final int RCC_UNKNOWN_PARAMETER = 51;
    public static final int RCC_FILE_IO_ERROR = 52;
    public static final int RCC_CORRUPTED_MIB_FILE = 53;
    public static final int RCC_TRANSFER_IN_PROGRESS = 54;
    public static final int RCC_INVALID_JOB_ID = 55;
    public static final int RCC_INVALID_SCRIPT_ID = 56;
    public static final int RCC_INVALID_SCRIPT_NAME = 57;
    public static final int RCC_UNKNOWN_MAP_NAME = 58;
    public static final int RCC_INVALID_MAP_ID = 59;
    public static final int RCC_ACCOUNT_DISABLED = 60;
    public static final int RCC_NO_GRACE_LOGINS = 61;
    public static final int RCC_CONNECTION_BROKEN = 62;
    public static final int RCC_INVALID_CONFIG_ID = 63;
    public static final int RCC_DB_CONNECTION_LOST = 64;
    public static final int RCC_ALARM_OPEN_IN_HELPDESK = 65;
    public static final int RCC_ALARM_NOT_OUTSTANDING = 66;
    public static final int RCC_NOT_PUSH_DCI = 67;
    public static final int RCC_NXMP_PARSE_ERROR = 68;
    public static final int RCC_NXMP_VALIDATION_ERROR = 69;
    public static final int RCC_INVALID_GRAPH_ID = 70;
    public static final int RCC_LOCAL_CRYPTO_ERROR = 71;
    public static final int RCC_UNSUPPORTED_AUTH_TYPE = 72;
    public static final int RCC_BAD_CERTIFICATE = 73;
    public static final int RCC_INVALID_CERT_ID = 74;
    public static final int RCC_SNMP_FAILURE = 75;
    public static final int RCC_NO_L2_TOPOLOGY_SUPPORT = 76;
    public static final int RCC_INVALID_SITUATION_ID = 77;
    public static final int RCC_INSTANCE_NOT_FOUND = 78;
    public static final int RCC_INVALID_EVENT_ID = 79;
    public static final int RCC_AGENT_ERROR = 80;
    public static final int RCC_UNKNOWN_VARIABLE = 81;
    public static final int RCC_RESOURCE_NOT_AVAILABLE = 82;
    public static final int RCC_JOB_CANCEL_FAILED = 83;
    public static final int USER_MODIFY_LOGIN_NAME = 1;
    public static final int USER_MODIFY_DESCRIPTION = 2;
    public static final int USER_MODIFY_FULL_NAME = 4;
    public static final int USER_MODIFY_FLAGS = 8;
    public static final int USER_MODIFY_ACCESS_RIGHTS = 16;
    public static final int USER_MODIFY_MEMBERS = 32;
    public static final int USER_MODIFY_CERT_MAPPING = 64;
    public static final int USER_MODIFY_AUTH_METHOD = 128;
    private static final int CLIENT_CHALLENGE_SIZE = 256;
    private static final int MAX_DCI_DATA_ROWS = 200000;
    private static final int MAX_DCI_STRING_VALUE_LENGTH = 256;
    private static final int RECEIVED_FILE_TTL = 300000;
    private final Semaphore syncObjects = new Semaphore(1);
    private final Semaphore syncUserDB = new Semaphore(1);
    private String connAddress;
    private int connPort;
    private String connLoginName;
    private String connPassword;
    private boolean connUseEncryption;
    private String connClientInfo = "nxjclient/0.9.0";
    private int userId;
    private int userSystemRights;
    private Socket connSocket = null;
    private NXCPMsgWaitQueue msgWaitQueue = null;
    private ReceiverThread recvThread = null;
    private HousekeeperThread housekeeperThread = null;
    private long requestId = 0L;
    private boolean isConnected = false;
    private int recvBufferSize = 0x400000;
    private int commandTimeout = 30000;
    private HashSet<NXCListener> listeners = new HashSet(0);
    private Map<Long, NXCReceivedFile> receivedFiles = new HashMap<Long, NXCReceivedFile>();
    private String serverVersion = "(unknown)";
    private byte[] serverId = new byte[8];
    private String serverTimeZone;
    private byte[] serverChallenge = new byte[256];
    private Map<Long, NXCObject> objectList = new HashMap<Long, NXCObject>();
    private Map<Long, NXCUserDBObject> userDB = new HashMap<Long, NXCUserDBObject>();

    private NXCObject createObjectFromMessage(NXCPMessage msg) {
        NXCObject object;
        int objectClass = msg.getVariableAsInteger(5L);
        switch (objectClass) {
            case 3: {
                object = new NXCInterface(msg, this);
                break;
            }
            case 1: {
                object = new NXCSubnet(msg, this);
                break;
            }
            case 5: {
                object = new NXCContainer(msg, this);
                break;
            }
            case 2: {
                object = new NXCNode(msg, this);
                break;
            }
            case 8: {
                object = new NXCTemplate(msg, this);
                break;
            }
            case 4: {
                object = new NXCEntireNetwork(msg, this);
                break;
            }
            case 7: {
                object = new NXCServiceRoot(msg, this);
                break;
            }
            case 16: {
                object = new NXCPolicyRoot(msg, this);
                break;
            }
            case 15: {
                object = new NXCPolicyGroup(msg, this);
                break;
            }
            case 17: {
                object = new NXCAgentPolicy(msg, this);
                break;
            }
            case 18: {
                object = new NXCAgentPolicyConfig(msg, this);
                break;
            }
            default: {
                object = new NXCObject(msg, this);
            }
        }
        return object;
    }

    public NXCSession(String connAddress, String connLoginName, String connPassword) {
        this.connAddress = connAddress;
        this.connPort = 4701;
        this.connLoginName = connLoginName;
        this.connPassword = connPassword;
        this.connUseEncryption = false;
    }

    public NXCSession(String connAddress, int connPort, String connLoginName, String connPassword) {
        this.connAddress = connAddress;
        this.connPort = connPort;
        this.connLoginName = connLoginName;
        this.connPassword = connPassword;
        this.connUseEncryption = false;
    }

    public NXCSession(String connAddress, int connPort, String connLoginName, String connPassword, boolean connUseEncryption) {
        this.connAddress = connAddress;
        this.connPort = connPort;
        this.connLoginName = connLoginName;
        this.connPassword = connPassword;
        this.connUseEncryption = connUseEncryption;
    }

    protected void finalize() {
        this.disconnect();
    }

    private void waitForSync(Semaphore syncObject, int timeout) throws NXCException {
        if (timeout == 0) {
            syncObject.acquireUninterruptibly();
        } else {
            long startTime;
            boolean success = false;
            for (long actualTimeout = (long)timeout; actualTimeout > 0L; actualTimeout -= System.currentTimeMillis() - startTime) {
                startTime = System.currentTimeMillis();
                try {
                    if (!this.syncObjects.tryAcquire(actualTimeout, TimeUnit.MILLISECONDS)) continue;
                    success = true;
                    this.syncObjects.release();
                    break;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (!success) {
                throw new NXCException(4);
            }
        }
    }

    private void completeSync(Semaphore syncObject) {
        syncObject.release();
    }

    public void addListener(NXCListener lst) {
        this.listeners.add(lst);
    }

    public void removeListener(NXCListener lst) {
        this.listeners.remove(lst);
    }

    protected synchronized void sendNotification(NXCNotification n) {
        Iterator<NXCListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().notificationHandler(n);
        }
    }

    public synchronized void sendMessage(NXCPMessage msg) throws IOException {
        this.connSocket.getOutputStream().write(msg.createNXCPMessage());
    }

    public NXCPMessage waitForMessage(int code, long id, int timeout) throws NXCException {
        NXCPMessage msg = this.msgWaitQueue.waitForMessage(code, id, timeout);
        if (msg == null) {
            throw new NXCException(4);
        }
        return msg;
    }

    public NXCPMessage waitForMessage(int code, long id) throws NXCException {
        NXCPMessage msg = this.msgWaitQueue.waitForMessage(code, id);
        if (msg == null) {
            throw new NXCException(4);
        }
        return msg;
    }

    public NXCPMessage waitForRCC(long id) throws NXCException {
        NXCPMessage msg = this.waitForMessage(29, id);
        int rcc = msg.getVariableAsInteger(28L);
        if (rcc != 0) {
            throw new NXCException(rcc);
        }
        return msg;
    }

    public final synchronized NXCPMessage newMessage(int code) {
        return new NXCPMessage(code, this.requestId++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File waitForFile(long id, int timeout) {
        int timeRemaining = timeout;
        File file = null;
        while (timeRemaining > 0) {
            Map<Long, NXCReceivedFile> map = this.receivedFiles;
            synchronized (map) {
                NXCReceivedFile rf = this.receivedFiles.get(id);
                if (rf != null && rf.getStatus() != 0) {
                    if (rf.getStatus() == 1) {
                        file = rf.getFile();
                    }
                    break;
                }
                long startTime = System.currentTimeMillis();
                try {
                    this.receivedFiles.wait(timeRemaining);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                timeRemaining = (int)((long)timeRemaining - (System.currentTimeMillis() - startTime));
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException, UnknownHostException, NXCException {
        try {
            this.connSocket = new Socket(this.connAddress, this.connPort);
            this.msgWaitQueue = new NXCPMsgWaitQueue(this.commandTimeout);
            this.recvThread = new ReceiverThread();
            this.housekeeperThread = new HousekeeperThread();
            NXCPMessage request = this.newMessage(103);
            this.sendMessage(request);
            NXCPMessage response = this.waitForMessage(29, request.getMessageId());
            if (response.getVariableAsInteger(146L) != 21) {
                throw new NXCException(40);
            }
            this.serverVersion = response.getVariableAsString(121L);
            this.serverId = response.getVariableAsBinary(142L);
            this.serverTimeZone = response.getVariableAsString(308L);
            this.serverChallenge = response.getVariableAsBinary(278L);
            if (this.connUseEncryption) {
                // empty if block
            }
            request = this.newMessage(1);
            request.setVariable(1L, this.connLoginName);
            request.setVariable(2L, this.connPassword);
            request.setVariableInt16(275L, 0);
            request.setVariable(177L, "0.9.0");
            request.setVariable(175L, this.connClientInfo);
            request.setVariable(176L, System.getProperty("os.name") + " " + System.getProperty("os.version"));
            this.sendMessage(request);
            response = this.waitForMessage(2, request.getMessageId());
            int rcc = response.getVariableAsInteger(28L);
            if (rcc != 0) {
                throw new NXCException(rcc);
            }
            this.userId = response.getVariableAsInteger(35L);
            this.userSystemRights = response.getVariableAsInteger(36L);
            this.isConnected = true;
        }
        finally {
            if (!this.isConnected) {
                this.disconnect();
            }
        }
    }

    public void disconnect() {
        if (this.connSocket != null) {
            try {
                this.connSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.recvThread != null) {
            while (this.recvThread.isAlive()) {
                try {
                    this.recvThread.join();
                }
                catch (InterruptedException e) {}
            }
            this.recvThread = null;
        }
        if (this.housekeeperThread != null) {
            this.housekeeperThread.setStopFlag(true);
            while (this.housekeeperThread.isAlive()) {
                try {
                    this.housekeeperThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.housekeeperThread = null;
        }
        this.connSocket = null;
        if (this.msgWaitQueue != null) {
            this.msgWaitQueue.shutdown();
            this.msgWaitQueue = null;
        }
        this.isConnected = false;
    }

    public int getRecvBufferSize() {
        return this.recvBufferSize;
    }

    public void setRecvBufferSize(int recvBufferSize) {
        this.recvBufferSize = recvBufferSize;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public byte[] getServerId() {
        return this.serverId;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public byte[] getServerChallenge() {
        return this.serverChallenge;
    }

    public String getConnClientInfo() {
        return this.connClientInfo;
    }

    public void setConnClientInfo(String connClientInfo) {
        this.connClientInfo = connClientInfo;
    }

    public void setCommandTimeout(int commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getUserSystemRights() {
        return this.userSystemRights;
    }

    public synchronized void syncObjects() throws IOException, NXCException {
        this.syncObjects.acquireUninterruptibly();
        NXCPMessage msg = this.newMessage(5);
        msg.setVariableInt16(254L, 1);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.waitForSync(this.syncObjects, this.commandTimeout * 10);
        this.subscribe(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NXCObject findObjectById(long id) {
        NXCObject obj;
        Map<Long, NXCObject> map = this.objectList;
        synchronized (map) {
            obj = this.objectList.get(id);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NXCObject[] findMultipleObjects(long[] idList) {
        ArrayList<NXCObject> result = new ArrayList<NXCObject>(idList.length);
        Map<Long, NXCObject> map = this.objectList;
        synchronized (map) {
            for (int i = 0; i < idList.length; ++i) {
                NXCObject object = this.objectList.get(idList[i]);
                if (object == null) continue;
                result.add(object);
            }
        }
        return result.toArray(new NXCObject[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NXCObject[] getTopLevelObjects() {
        HashSet<NXCObject> list = new HashSet<NXCObject>();
        Map<Long, NXCObject> map = this.objectList;
        synchronized (map) {
            for (NXCObject object : this.objectList.values()) {
                if (object.getNumberOfParents() == 0) {
                    list.add(object);
                    continue;
                }
                boolean hasParents = false;
                Iterator<Long> it = object.getParents();
                while (it.hasNext()) {
                    Long parent = it.next();
                    if (!this.objectList.containsKey(parent)) continue;
                    hasParents = true;
                    break;
                }
                if (hasParents) continue;
                list.add(object);
            }
        }
        return list.toArray(new NXCObject[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NXCObject[] getAllObjects() {
        NXCObject[] list;
        Map<Long, NXCObject> map = this.objectList;
        synchronized (map) {
            list = this.objectList.values().toArray(new NXCObject[this.objectList.size()]);
        }
        return list;
    }

    public HashMap<Long, NXCAlarm> getAlarms(boolean getTerminated) throws IOException, NXCException {
        long alarmId;
        NXCPMessage msg = this.newMessage(70);
        long rqId = msg.getMessageId();
        msg.setVariableInt16(96L, getTerminated ? 1 : 0);
        this.sendMessage(msg);
        HashMap<Long, NXCAlarm> alarmList = new HashMap<Long, NXCAlarm>(0);
        while ((alarmId = (long)(msg = this.waitForMessage(74, rqId)).getVariableAsInteger(93L)) != 0L) {
            alarmList.put(alarmId, new NXCAlarm(msg));
        }
        return alarmList;
    }

    public void acknowledgeAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(72);
        msg.setVariableInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void terminateAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(181);
        msg.setVariableInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(75);
        msg.setVariableInt32(93L, (int)alarmId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void openAlarm(long alarmId, String reference) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(4);
        msg.setVariableInt32(93L, (int)alarmId);
        msg.setVariableInt16(246L, 1);
        msg.setVariable(247L, reference);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void closeAlarm(long alarmId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(4);
        msg.setVariableInt32(93L, (int)alarmId);
        msg.setVariableInt16(246L, 2);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public HashMap<String, NXCServerVariable> getServerVariables() throws IOException, NXCException {
        NXCPMessage request = this.newMessage(13);
        this.sendMessage(request);
        NXCPMessage response = this.waitForRCC(request.getMessageId());
        int count = response.getVariableAsInteger(144L);
        HashMap<String, NXCServerVariable> varList = new HashMap<String, NXCServerVariable>(count);
        int i = 0;
        long id = 0x10000000L;
        while (i < count) {
            String name = response.getVariableAsString(id);
            varList.put(name, new NXCServerVariable(name, response.getVariableAsString(id + 1L), response.getVariableAsBoolean(id + 2L)));
            ++i;
            id += 3L;
        }
        return varList;
    }

    public void setServerVariable(String name, String value) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(14);
        msg.setVariable(20L, name);
        msg.setVariable(21L, value);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deleteServerVariable(String name) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(17);
        msg.setVariable(20L, name);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void subscribe(int channels) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(138);
        msg.setVariableInt32(13L, channels);
        msg.setVariableInt16(172L, 1);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void unsubscribe(int channels) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(138);
        msg.setVariableInt32(13L, channels);
        msg.setVariableInt16(172L, 0);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void syncUserDatabase() throws IOException, NXCException {
        this.syncUserDB.acquireUninterruptibly();
        NXCPMessage msg = this.newMessage(30);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
        this.waitForSync(this.syncUserDB, this.commandTimeout * 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NXCUserDBObject findUserDBObjectById(long id) {
        NXCUserDBObject object;
        Map<Long, NXCUserDBObject> map = this.userDB;
        synchronized (map) {
            object = this.userDB.get(id);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NXCUserDBObject[] getUserDatabaseObjects() {
        NXCUserDBObject[] list;
        Map<Long, NXCUserDBObject> map = this.userDB;
        synchronized (map) {
            Collection<NXCUserDBObject> values = this.userDB.values();
            list = values.toArray(new NXCUserDBObject[values.size()]);
        }
        return list;
    }

    private long createUserDBObject(String name, boolean isGroup) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(36);
        msg.setVariable(34L, name);
        msg.setVariableInt16(39L, isGroup ? 1 : 0);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(35L);
    }

    public long createUser(String name) throws IOException, NXCException {
        return this.createUserDBObject(name, false);
    }

    public long createUserGroup(String name) throws IOException, NXCException {
        return this.createUserDBObject(name, true);
    }

    public void deleteUserDBObject(long id) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(35);
        msg.setVariableInt32(35L, (int)id);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setUserPassword(long id, String password) throws IOException, NXCException {
        MessageDigest md;
        NXCPMessage msg = this.newMessage(40);
        msg.setVariableInt32(35L, (int)id);
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new NXCException(46);
        }
        byte[] digest = md.digest(password.getBytes());
        msg.setVariable(2L, digest);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifyUserDBObject(NXCUserDBObject object, int fields) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(34);
        msg.setVariableInt32(337L, fields);
        object.fillMessage(msg);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifyUserDBObject(NXCUserDBObject object) throws IOException, NXCException {
        this.modifyUserDBObject(object, Integer.MAX_VALUE);
    }

    public void lockUserDatabase() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(37);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void unlockUserDatabase() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(38);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public NXCDCIValue[] getLastValues(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(121);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(111L);
        NXCDCIValue[] list = new NXCDCIValue[count];
        long base = 0x10000000L;
        int i = 0;
        while (i < count) {
            list[i] = new NXCDCIValue(nodeId, response, base);
            ++i;
            base += 10L;
        }
        return list;
    }

    private int parseDataRows(byte[] input, NXCDCIData data) {
        NXCPDataInputStream inputStream = new NXCPDataInputStream(input);
        int rows = 0;
        try {
            inputStream.skipBytes(4);
            rows = inputStream.readInt();
            int dataType = inputStream.readInt();
            block9: for (int i = 0; i < rows; ++i) {
                long timestamp = inputStream.readUnsignedInt() * 1000L;
                switch (dataType) {
                    case 0: {
                        data.addDataRow(new NXCDCIDataRow(new Date(timestamp), new Long(inputStream.readInt())));
                        continue block9;
                    }
                    case 1: {
                        data.addDataRow(new NXCDCIDataRow(new Date(timestamp), new Long(inputStream.readUnsignedInt())));
                        continue block9;
                    }
                    case 2: 
                    case 3: {
                        data.addDataRow(new NXCDCIDataRow(new Date(timestamp), new Long(inputStream.readLong())));
                        continue block9;
                    }
                    case 5: {
                        data.addDataRow(new NXCDCIDataRow(new Date(timestamp), new Double(inputStream.readDouble())));
                        continue block9;
                    }
                    case 4: {
                        int count;
                        StringBuilder sb = new StringBuilder(256);
                        for (count = 256; count > 0; --count) {
                            char ch = inputStream.readChar();
                            if (ch == '\u0000') {
                                --count;
                                break;
                            }
                            sb.append(ch);
                        }
                        inputStream.skipBytes(count);
                        data.addDataRow(new NXCDCIDataRow(new Date(timestamp), sb.toString()));
                    }
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return rows;
    }

    public NXCDCIData getCollectedData(long nodeId, long dciId, Date from, Date to, int maxRows) throws IOException, NXCException {
        int rowsReceived;
        NXCPMessage msg = this.newMessage(49);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariableInt32(43L, (int)dciId);
        NXCDCIData data = new NXCDCIData(nodeId, dciId);
        int rowsRemaining = maxRows;
        int timeFrom = from != null ? (int)(from.getTime() / 1000L) : 0;
        int timeTo = to != null ? (int)(to.getTime() / 1000L) : 0;
        do {
            NXCDCIDataRow row;
            msg.setMessageId(this.requestId++);
            msg.setVariableInt32(50L, maxRows);
            msg.setVariableInt32(51L, timeFrom);
            msg.setVariableInt32(52L, timeTo);
            this.sendMessage(msg);
            this.waitForRCC(msg.getMessageId());
            NXCPMessage response = this.waitForMessage(50, msg.getMessageId());
            if (!response.isRawMessage()) {
                throw new NXCException(46);
            }
            rowsReceived = this.parseDataRows(response.getBinaryData(), data);
            if (rowsRemaining != 0 && rowsRemaining <= 200000 || rowsReceived != 200000) continue;
            if (rowsRemaining > 0) {
                rowsRemaining -= rowsReceived;
            }
            if (to == null || (row = data.getLastValue()) == null) continue;
            timeTo = (int)(row.getTimestamp().getTime() / 1000L) - 1;
        } while (rowsReceived == 200000);
        return data;
    }

    public long createObject(NXCObjectCreationData data) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(55);
        msg.setVariableInt32(78L, (int)data.getParentId());
        msg.setVariableInt16(5L, data.getObjectClass());
        msg.setVariable(4L, data.getName());
        if (data.getComments() != null) {
            msg.setVariable(82L, data.getComments());
        }
        switch (data.getObjectClass()) {
            case 2: {
                msg.setVariable(8L, data.getIpAddress());
                msg.setVariable(9L, data.getIpNetMask());
                msg.setVariableInt32(14L, data.getCreationFlags());
                msg.setVariableInt32(195L, (int)data.getAgentProxyId());
                msg.setVariableInt32(267L, (int)data.getSnmpProxyId());
            }
        }
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        return response.getVariableAsInt64(3L);
    }

    public void deleteObject(long objectId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(7);
        msg.setVariableInt32(3L, (int)objectId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void modifyObject(NXCObjectModificationData data) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(8);
        msg.setVariableInt32(3L, (int)data.getObjectId());
        long flags = data.getFlags();
        if (flags == 0L) {
            return;
        }
        if ((flags & 1L) != 0L) {
            msg.setVariable(4L, data.getName());
        }
        if ((flags & 2L) != 0L) {
            NXCAccessListElement[] acl = data.getACL();
            msg.setVariableInt32(32L, acl.length);
            msg.setVariableInt16(33L, data.isInheritAccessRights() ? 1 : 0);
            long id1 = 4096L;
            long id2 = 8192L;
            for (int i = 0; i < acl.length; ++i) {
                msg.setVariableInt32(id1++, acl[i].getUserId());
                msg.setVariableInt32(id2++, acl[i].getAccessRights());
            }
        }
        if ((flags & 4L) != 0L) {
            Map<String, String> attrList = data.getCustomAttributes();
            Iterator<String> it = attrList.keySet().iterator();
            long id = 0x70000000L;
            int count = 0;
            while (it.hasNext()) {
                String key = it.next();
                String value = attrList.get(key);
                msg.setVariable(id++, key);
                msg.setVariable(id++, value);
                ++count;
            }
            msg.setVariableInt32(309L, count);
        }
        if ((flags & 8L) != 0L) {
            msg.setVariableInt16(170L, data.isAutoApplyEnabled() ? 1 : 0);
            msg.setVariable(319L, data.getAutoApplyFilter());
        }
        if ((flags & 0x10L) != 0L) {
            msg.setVariableInt16(320L, data.isAutoBindEnabled() ? 1 : 0);
            msg.setVariable(321L, data.getAutoBindFilter());
        }
        if ((flags & 0x80L) != 0L) {
            msg.setVariable(27L, data.getDescription());
        }
        if ((flags & 0x40L) != 0L) {
            msg.setVariableInt32(178L, data.getVersion());
        }
        if ((flags & 0x20L) != 0L) {
            msg.setVariable(80L, data.getConfigFileName());
            msg.setVariable(81L, data.getConfigFileContent());
        }
        if ((flags & 0x100L) != 0L) {
            msg.setVariableInt16(15L, data.getAgentPort());
        }
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void setObjectName(long objectId, String name) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setName(name);
        this.modifyObject(data);
    }

    public void setObjectCustomAttributes(long objectId, Map<String, String> attrList) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setCustomAttributes(attrList);
        this.modifyObject(data);
    }

    public void setObjectACL(long objectId, NXCAccessListElement[] acl, boolean inheritAccessRights) throws IOException, NXCException {
        NXCObjectModificationData data = new NXCObjectModificationData(objectId);
        data.setACL(acl);
        data.setInheritAccessRights(inheritAccessRights);
        this.modifyObject(data);
    }

    public void changeNodeIpAddress(long nodeId, InetAddress addr) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(129);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariable(8L, addr);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public NXCMapPage queryLayer2Topology(long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(205);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(138L);
        long[] idList = response.getVariableAsUInt32Array(139L);
        if (idList.length != count) {
            throw new NXCException(46);
        }
        NXCMapPage page = new NXCMapPage();
        for (int i = 0; i < count; ++i) {
            page.addObject(new NXCMapObjectData(idList[i]));
        }
        count = response.getVariableAsInteger(214L);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            long obj1 = response.getVariableAsInt64(varId++);
            long obj2 = response.getVariableAsInt64(varId++);
            int type = response.getVariableAsInteger(varId++);
            String port1 = response.getVariableAsString(varId++);
            String port2 = response.getVariableAsString(varId++);
            page.addLink(new NXCMapObjectLink(type, obj1, obj2, port1, port2));
            ++i;
            varId += 5L;
        }
        return page;
    }

    public void executeAction(long nodeId, String action) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(16);
        msg.setVariableInt32(3L, (int)nodeId);
        msg.setVariable(87L, action);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public NXCServerJob[] getServerJobList() throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(54);
        this.sendMessage(msg);
        NXCPMessage response = this.waitForRCC(msg.getMessageId());
        int count = response.getVariableAsInteger(330L);
        NXCServerJob[] jobList = new NXCServerJob[count];
        long baseVarId = 0x10000000L;
        int i = 0;
        while (i < count) {
            jobList[i] = new NXCServerJob(response, baseVarId);
            ++i;
            baseVarId += 10L;
        }
        return jobList;
    }

    public void cancelServerJob(long jobId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(137);
        msg.setVariableInt32(331L, (int)jobId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void deployAgentPolicy(long policyId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(142);
        msg.setVariableInt32(83L, (int)policyId);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    public void uninstallAgentPolicy(long policyId, long nodeId) throws IOException, NXCException {
        NXCPMessage msg = this.newMessage(60);
        msg.setVariableInt32(83L, (int)policyId);
        msg.setVariableInt32(3L, (int)nodeId);
        this.sendMessage(msg);
        this.waitForRCC(msg.getMessageId());
    }

    private class HousekeeperThread
    extends Thread {
        private boolean stopFlag = false;

        HousekeeperThread() {
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stopFlag) {
                try {
                    HousekeeperThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Map map = NXCSession.this.receivedFiles;
                synchronized (map) {
                    long currTime = System.currentTimeMillis();
                    Iterator it = NXCSession.this.receivedFiles.values().iterator();
                    while (it.hasNext()) {
                        NXCReceivedFile file = (NXCReceivedFile)it.next();
                        if (file.getTimestamp() + 300000L >= currTime) continue;
                        it.remove();
                    }
                }
            }
        }

        public void setStopFlag(boolean stopFlag) {
            this.stopFlag = stopFlag;
        }
    }

    private class ReceiverThread
    extends Thread {
        ReceiverThread() {
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InputStream in;
            NXCPMessageReceiver receiver = new NXCPMessageReceiver(NXCSession.this.recvBufferSize);
            try {
                in = NXCSession.this.connSocket.getInputStream();
            }
            catch (IOException e) {
                return;
            }
            block25: while (NXCSession.this.connSocket.isConnected()) {
                try {
                    NXCPMessage msg = receiver.receiveMessage(in);
                    switch (msg.getMessageCode()) {
                        case 6: 
                        case 10: {
                            NXCObject obj = NXCSession.this.createObjectFromMessage(msg);
                            Map map = NXCSession.this.objectList;
                            synchronized (map) {
                                if (obj.isDeleted()) {
                                    NXCSession.this.objectList.remove(obj.getObjectId());
                                } else {
                                    NXCSession.this.objectList.put(obj.getObjectId(), obj);
                                }
                            }
                            if (msg.getMessageCode() != 10) continue block25;
                            NXCSession.this.sendNotification(new NXCNotification(4, obj));
                            break;
                        }
                        case 9: {
                            NXCSession.this.completeSync(NXCSession.this.syncObjects);
                            break;
                        }
                        case 31: {
                            NXCUser user = new NXCUser(msg);
                            Map map = NXCSession.this.userDB;
                            synchronized (map) {
                                if (user.isDeleted()) {
                                    NXCSession.this.userDB.remove(user.getId());
                                } else {
                                    NXCSession.this.userDB.put(user.getId(), user);
                                }
                                break;
                            }
                        }
                        case 32: {
                            NXCUserGroup group = new NXCUserGroup(msg);
                            Map map = NXCSession.this.userDB;
                            synchronized (map) {
                                if (group.isDeleted()) {
                                    NXCSession.this.userDB.remove(group.getId());
                                } else {
                                    NXCSession.this.userDB.put(group.getId(), group);
                                }
                                break;
                            }
                        }
                        case 33: {
                            NXCSession.this.completeSync(NXCSession.this.syncUserDB);
                            break;
                        }
                        case 39: {
                            this.processUserDBUpdate(msg);
                            break;
                        }
                        case 73: {
                            NXCSession.this.sendNotification(new NXCNotification(msg.getVariableAsInteger(23L) + 1000, new NXCAlarm(msg)));
                            break;
                        }
                        case 141: {
                            NXCSession.this.sendNotification(new NXCNotification(10, new NXCServerJob(msg)));
                            break;
                        }
                        case 105: {
                            this.processFileData(msg);
                            break;
                        }
                        default: {
                            if (msg.getMessageCode() >= 4096) {
                                NXCSession.this.sendNotification(new NXCNotification(2000, msg));
                            }
                            NXCSession.this.msgWaitQueue.putMessage(msg);
                        }
                    }
                }
                catch (IOException e) {
                    break;
                }
                catch (NXCPException nXCPException) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFileData(NXCPMessage msg) {
            NXCReceivedFile file;
            long id = msg.getMessageId();
            Map map = NXCSession.this.receivedFiles;
            synchronized (map) {
                file = (NXCReceivedFile)NXCSession.this.receivedFiles.get(id);
                if (file == null) {
                    file = new NXCReceivedFile(id);
                    NXCSession.this.receivedFiles.put(id, file);
                }
            }
            file.writeData(msg.getBinaryData());
            if (msg.isEndOfFileSet()) {
                file.close();
                map = NXCSession.this.receivedFiles;
                synchronized (map) {
                    NXCSession.this.receivedFiles.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processUserDBUpdate(NXCPMessage msg) {
            int code = msg.getVariableAsInteger(42L);
            long id = msg.getVariableAsInt64(35L);
            NXCUserDBObject object = null;
            switch (code) {
                case 0: 
                case 2: {
                    object = (id & Integer.MIN_VALUE) != 0L ? new NXCUserGroup(msg) : new NXCUser(msg);
                    Map map = NXCSession.this.userDB;
                    synchronized (map) {
                        NXCSession.this.userDB.put(id, object);
                        break;
                    }
                }
                case 1: {
                    Map map = NXCSession.this.userDB;
                    synchronized (map) {
                        object = (NXCUserDBObject)NXCSession.this.userDB.get(id);
                        if (object != null) {
                            NXCSession.this.userDB.remove(id);
                        }
                        break;
                    }
                }
            }
            if (object != null) {
                NXCSession.this.sendNotification(new NXCNotification(3, code, object));
            }
        }
    }
}

