/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCUserDBObject;

public class NXCUserGroup
extends NXCUserDBObject {
    private long[] members;

    public NXCUserGroup(String name) {
        super(name);
        this.members = new long[0];
    }

    public NXCUserGroup(NXCUserGroup src) {
        super(src);
        this.members = new long[src.members.length];
        System.arraycopy(src.members, 0, this.members, 0, src.members.length);
    }

    protected NXCUserGroup(NXCPMessage msg) {
        super(msg);
        int count = msg.getVariableAsInteger(38L);
        this.members = new long[count];
        for (int i = 0; i < count; ++i) {
            this.members[i] = msg.getVariableAsInt64(16384L + (long)i);
        }
    }

    public void fillMessage(NXCPMessage msg) {
        super.fillMessage(msg);
        msg.setVariableInt32(38L, this.members.length);
        for (int i = 0; i < this.members.length; ++i) {
            msg.setVariableInt32(16384L + (long)i, (int)this.members[i]);
        }
    }

    public long[] getMembers() {
        return this.members;
    }

    public void setMembers(long[] members) {
        this.members = members;
    }

    public Object clone() throws CloneNotSupportedException {
        return new NXCUserGroup(this);
    }
}

