/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

public final class NXCAccessListElement {
    private long userId;
    private int accessRights;

    public NXCAccessListElement(long userId, int accessRights) {
        this.userId = userId;
        this.accessRights = accessRights;
    }

    public NXCAccessListElement(NXCAccessListElement src) {
        this.userId = src.userId;
        this.accessRights = src.accessRights;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setAccessRights(int accessRights) {
        this.accessRights = accessRights;
    }

    public int getAccessRights() {
        return this.accessRights;
    }

    public boolean hasRead() {
        return (this.accessRights & 1) != 0;
    }

    public boolean hasModify() {
        return (this.accessRights & 2) != 0;
    }

    public boolean hasDelete() {
        return (this.accessRights & 8) != 0;
    }

    public boolean hasCreate() {
        return (this.accessRights & 4) != 0;
    }

    public boolean hasReadAlarms() {
        return (this.accessRights & 0x10) != 0;
    }

    public boolean hasAckAlarms() {
        return (this.accessRights & 0x40) != 0;
    }

    public boolean hasTerminateAlarms() {
        return (this.accessRights & 0x200) != 0;
    }

    public boolean hasControl() {
        return (this.accessRights & 0x100) != 0;
    }

    public boolean hasSendEvents() {
        return (this.accessRights & 0x80) != 0;
    }

    public boolean hasAccessControl() {
        return (this.accessRights & 0x20) != 0;
    }

    public boolean hasPushData() {
        return (this.accessRights & 0x400) != 0;
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof NXCAccessListElement)) {
            return false;
        }
        return this.userId == ((NXCAccessListElement)aThat).userId && this.accessRights == ((NXCAccessListElement)aThat).accessRights;
    }

    public int hashCode() {
        return (int)((long)(this.accessRights << 16) & this.userId);
    }
}

