/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    private List<String> columns;
    private List<List<String>> data;

    public Table() {
        this.columns = new ArrayList<String>(0);
        this.data = new ArrayList<List<String>>(0);
    }

    public Table(NXCPMessage msg) {
        int columnCount = msg.getVariableAsInteger(329L);
        this.columns = new ArrayList<String>(columnCount);
        long varId = 0x10000000L;
        int i = 0;
        while (i < columnCount) {
            this.columns.add(msg.getVariableAsString(varId++));
            ++i;
            varId += 9L;
        }
        int rowCount = msg.getVariableAsInteger(328L);
        this.data = new ArrayList<List<String>>(rowCount);
        varId = 0x20000000L;
        int i2 = 0;
        while (i2 < rowCount) {
            ArrayList<String> row = new ArrayList<String>(columnCount);
            int j = 0;
            while (j < columnCount) {
                row.add(msg.getVariableAsString(varId++));
                ++j;
            }
            this.data.add(row);
            ++i2;
        }
    }

    public void addDataFromMessage(NXCPMessage msg) {
        int rowCount = msg.getVariableAsInteger(328L);
        long varId = 0x20000000L;
        int i = 0;
        while (i < rowCount) {
            ArrayList<String> row = new ArrayList<String>(this.columns.size());
            int j = 0;
            while (j < this.columns.size()) {
                row.add(msg.getVariableAsString(varId++));
                ++j;
            }
            this.data.add(row);
            ++i;
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int column) throws IndexOutOfBoundsException {
        return this.columns.get(column);
    }

    public int getColumnIndex(String name) {
        return this.columns.indexOf(name);
    }

    public String getCell(int row, int column) throws IndexOutOfBoundsException {
        List<String> rowData = this.data.get(row);
        return rowData.get(column);
    }

    public List<String> getRow(int row) throws IndexOutOfBoundsException {
        return this.data.get(row);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Table");
        sb.append("{columns=").append(this.columns);
        sb.append(", data=").append(this.data);
        sb.append('}');
        return sb.toString();
    }
}

