/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessage;

public class NXCPMessageReceiver {
    private byte[] recvBuffer;
    private int bufferPos = 0;

    public NXCPMessageReceiver(int bufferSize) {
        this.recvBuffer = new byte[bufferSize];
    }

    private int getMessageSize(byte[] header) throws IOException {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(header));
        inputStream.skipBytes(4);
        return inputStream.readInt();
    }

    private NXCPMessage getMessageFromBuffer() throws IOException, NXCPException {
        NXCPMessage msg = null;
        if (this.bufferPos >= 16) {
            int size = this.getMessageSize(this.recvBuffer);
            if (size <= this.bufferPos) {
                msg = new NXCPMessage(this.recvBuffer);
                System.arraycopy(this.recvBuffer, size, this.recvBuffer, 0, this.bufferPos - size);
                this.bufferPos -= size;
            } else if (size > this.recvBuffer.length) {
                throw new NXCPException(1);
            }
        }
        return msg;
    }

    public NXCPMessage receiveMessage(InputStream in) throws IOException, NXCPException {
        NXCPMessage msg = null;
        while ((msg = this.getMessageFromBuffer()) == null) {
            int bytes = in.read(this.recvBuffer, this.bufferPos, this.recvBuffer.length - this.bufferPos);
            this.bufferPos += bytes;
        }
        return msg;
    }
}

