/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCUserDBObject;

public class NXCUserGroup
extends NXCUserDBObject {
    private long[] members;

    public NXCUserGroup(String name) {
        super(name);
        this.members = new long[0];
    }

    public NXCUserGroup(NXCUserGroup src) {
        super(src);
        this.members = new long[src.members.length];
        System.arraycopy(src.members, 0, this.members, 0, src.members.length);
    }

    protected NXCUserGroup(NXCPMessage msg) {
        super(msg);
        int count = msg.getVariableAsInteger(38L);
        this.members = new long[count];
        int i = 0;
        while (i < count) {
            this.members[i] = msg.getVariableAsInt64(16384L + (long)i);
            ++i;
        }
    }

    public void fillMessage(NXCPMessage msg) {
        super.fillMessage(msg);
        msg.setVariableInt32(38L, this.members.length);
        int i = 0;
        while (i < this.members.length) {
            msg.setVariableInt32(16384L + (long)i, (int)this.members[i]);
            ++i;
        }
    }

    public long[] getMembers() {
        return this.members;
    }

    public void setMembers(long[] members) {
        this.members = members;
    }

    public Object clone() throws CloneNotSupportedException {
        return new NXCUserGroup(this);
    }
}

