/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netxms.client.NXCObject;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.NetworkMapObjectData;
import org.netxms.client.maps.NetworkMapObjectLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkMapPage {
    private String name;
    private Set<NetworkMapObjectData> objects = new HashSet<NetworkMapObjectData>(0);
    private Set<NetworkMapObjectLink> links = new HashSet<NetworkMapObjectLink>(0);

    public NetworkMapPage() {
        this.name = "";
    }

    public NetworkMapPage(String name) {
        this.name = name;
    }

    public void addObject(NetworkMapObjectData object) {
        this.objects.add(object);
    }

    public void addLink(NetworkMapObjectLink link) {
        this.links.add(link);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<NetworkMapObjectData> getObjects() {
        return this.objects;
    }

    public Set<NetworkMapObjectLink> getLinks() {
        return this.links;
    }

    public Object[] getObjectsAndLinks(NXCSession session) {
        Object[] list = new Object[this.objects.size() + this.links.size()];
        Iterator<NetworkMapObjectData> oit = this.objects.iterator();
        int i = 0;
        while (oit.hasNext()) {
            NetworkMapObjectData data = oit.next();
            long id = data.getObjectId();
            list[i] = session.findObjectById(id);
            ++i;
        }
        Iterator<NetworkMapObjectLink> lit = this.links.iterator();
        int i2 = this.objects.size();
        while (lit.hasNext()) {
            list[i2] = lit.next();
            ++i2;
        }
        return list;
    }

    public NXCObject[] getResolvedObjects(NXCSession session) {
        NXCObject[] list = new NXCObject[this.objects.size()];
        Iterator<NetworkMapObjectData> it = this.objects.iterator();
        int i = 0;
        while (it.hasNext()) {
            NetworkMapObjectData data = it.next();
            long id = data.getObjectId();
            list[i] = session.findObjectById(id);
            ++i;
        }
        return list;
    }

    public NXCObject[] getConnectedObjects(long root, NXCSession session) {
        HashSet<NXCObject> result = new HashSet<NXCObject>(0);
        for (NetworkMapObjectLink link : this.links) {
            NXCObject object;
            long id;
            if (link.getObject1() == root) {
                id = link.getObject2();
                object = session.findObjectById(id);
                if (object == null) continue;
                result.add(object);
                continue;
            }
            if (link.getObject1() != root || (object = session.findObjectById(id = link.getObject1())) == null) continue;
            result.add(object);
        }
        return result.toArray(new NXCObject[result.size()]);
    }
}

