/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class NXCReceivedFile {
    public static final int OPEN = 0;
    public static final int RECEIVED = 1;
    public static final int FAILED = 2;
    private long id;
    private File file;
    private FileOutputStream stream;
    private int status;
    private long timestamp;
    private long size;
    private IOException exception;

    protected NXCReceivedFile(long id) {
        this.id = id;
        try {
            this.file = File.createTempFile("nxc", "data");
            this.file.deleteOnExit();
            this.stream = new FileOutputStream(this.file);
            this.timestamp = System.currentTimeMillis();
            this.status = 0;
            this.size = 0L;
        }
        catch (IOException e) {
            this.exception = e;
            this.status = 2;
        }
    }

    protected void writeData(byte[] data) {
        if (this.status == 0) {
            try {
                this.stream.write(data);
                this.size += (long)data.length;
            }
            catch (IOException e) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.status = 2;
                this.exception = e;
            }
            this.timestamp = System.currentTimeMillis();
        }
    }

    protected void close() {
        if (this.status == 0) {
            try {
                this.stream.close();
                this.status = 1;
            }
            catch (IOException e) {
                this.status = 2;
                this.exception = e;
            }
            this.timestamp = System.currentTimeMillis();
        }
    }

    public long getId() {
        return this.id;
    }

    public File getFile() {
        return this.file;
    }

    public int getStatus() {
        return this.status;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSize() {
        return this.size;
    }

    public IOException getException() {
        return this.exception != null ? this.exception : new IOException();
    }
}

