/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.dashboards;

import org.netxms.base.NXCPMessage;

public class DashboardElement {
    public static final int LABEL = 0;
    public static final int LINE_CHART = 1;
    public static final int BAR_CHART = 2;
    public static final int PIE_CHART = 3;
    public static final int STATUS_INDICATOR = 4;
    public static final int FILL = 0;
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private int type;
    private String data;
    private int horizontalSpan;
    private int verticalSpan;
    private int horizontalAlignment;
    private int verticalAlignment;

    public DashboardElement(int type, String data) {
        this.type = type;
        this.data = data;
        this.horizontalSpan = 1;
        this.verticalSpan = 1;
        this.horizontalAlignment = 0;
        this.verticalAlignment = 0;
    }

    public DashboardElement(NXCPMessage msg, long baseId) {
        this.type = msg.getVariableAsInteger(baseId);
        this.data = msg.getVariableAsString(baseId + 1L);
        this.horizontalSpan = msg.getVariableAsInteger(baseId + 2L);
        this.verticalSpan = msg.getVariableAsInteger(baseId + 3L);
        this.horizontalAlignment = msg.getVariableAsInteger(baseId + 4L);
        this.verticalAlignment = msg.getVariableAsInteger(baseId + 5L);
    }

    public DashboardElement(DashboardElement src) {
        this.type = src.type;
        this.data = src.data;
        this.horizontalSpan = src.horizontalSpan;
        this.verticalSpan = src.verticalSpan;
        this.horizontalAlignment = src.horizontalAlignment;
        this.verticalAlignment = src.verticalAlignment;
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setVariableInt16(baseId, this.type);
        msg.setVariable(baseId + 1L, this.data);
        msg.setVariableInt16(baseId + 2L, this.horizontalSpan);
        msg.setVariableInt16(baseId + 3L, this.verticalSpan);
        msg.setVariableInt16(baseId + 4L, this.horizontalAlignment);
        msg.setVariableInt16(baseId + 5L, this.verticalAlignment);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public int getHorizontalSpan() {
        return this.horizontalSpan;
    }

    public void setHorizontalSpan(int horizontalSpan) {
        this.horizontalSpan = horizontalSpan;
    }

    public int getVerticalSpan() {
        return this.verticalSpan;
    }

    public void setVerticalSpan(int verticalSpan) {
        this.verticalSpan = verticalSpan;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public int getType() {
        return this.type;
    }
}

