/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.io.IOException;
import java.util.HashMap;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionItem;

public class DataCollectionConfiguration {
    private NXCSession session;
    private long nodeId;
    private HashMap<Long, DataCollectionItem> items;
    private boolean isOpen = false;
    private Object userData = null;

    public DataCollectionConfiguration(NXCSession session, long nodeId) {
        this.session = session;
        this.nodeId = nodeId;
        this.items = new HashMap(0);
    }

    public void open() throws IOException, NXCException {
        NXCPMessage response;
        NXCPMessage msg = this.session.newMessage(41);
        msg.setVariableInt32(3L, (int)this.nodeId);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
        while (!(response = this.session.waitForMessage(42, msg.getMessageId())).isEndOfSequence()) {
            DataCollectionItem item = new DataCollectionItem(this, response);
            this.items.put(item.getId(), item);
        }
        this.isOpen = true;
    }

    public void close() throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(46);
        msg.setVariableInt32(3L, (int)this.nodeId);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
        this.items.clear();
        this.isOpen = false;
    }

    public DataCollectionItem[] getItems() {
        return this.items.values().toArray(new DataCollectionItem[this.items.size()]);
    }

    public DataCollectionItem findItem(long id) {
        return this.items.get(id);
    }

    public long createItem() throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(48);
        msg.setVariableInt32(3L, (int)this.nodeId);
        this.session.sendMessage(msg);
        NXCPMessage response = this.session.waitForRCC(msg.getMessageId());
        long id = response.getVariableAsInt64(43L);
        this.items.put(id, new DataCollectionItem(this, id));
        return id;
    }

    public void modifyItem(long itemId) throws IOException, NXCException {
        DataCollectionItem item = this.items.get(itemId);
        if (item == null) {
            throw new NXCException(14);
        }
        this.modifyItem(item);
    }

    public void modifyItem(DataCollectionItem item) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(45);
        msg.setVariableInt32(3L, (int)this.nodeId);
        item.fillMessage(msg);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
    }

    private void copyItemsInternal(long destNodeId, long[] items, boolean move) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(91);
        msg.setVariableInt32(109L, (int)this.nodeId);
        msg.setVariableInt32(110L, (int)destNodeId);
        msg.setVariableInt16(220L, move ? 1 : 0);
        msg.setVariableInt32(111L, items.length);
        msg.setVariable(112L, items);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
    }

    public void copyItems(long destNodeId, long[] items) throws IOException, NXCException {
        this.copyItemsInternal(destNodeId, items, false);
    }

    public void moveItems(long destNodeId, long[] items) throws IOException, NXCException {
        this.copyItemsInternal(destNodeId, items, true);
    }

    public void clearCollectedData(long itemId) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(228);
        msg.setVariableInt32(3L, (int)this.nodeId);
        msg.setVariableInt32(43L, (int)itemId);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
    }

    public void setItemStatus(long[] items, int status) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(104);
        msg.setVariableInt32(3L, (int)this.nodeId);
        msg.setVariableInt16(48L, status);
        msg.setVariableInt32(111L, items.length);
        msg.setVariable(112L, items);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
    }

    public void deleteItem(long itemId) throws IOException, NXCException {
        NXCPMessage msg = this.session.newMessage(44);
        msg.setVariableInt32(3L, (int)this.nodeId);
        msg.setVariableInt32(43L, (int)itemId);
        this.session.sendMessage(msg);
        this.session.waitForRCC(msg.getMessageId());
        this.items.remove(itemId);
    }

    protected void finalize() throws Throwable {
        if (this.isOpen) {
            this.close();
        }
        super.finalize();
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }
}

