/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netxms.base.NXCPMessage;
import org.netxms.client.AccessListElement;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.GraphItemStyle;
import org.netxms.client.datacollection.GraphSettingsChangeListener;

public class GraphSettings {
    public static final int MAX_GRAPH_ITEM_COUNT = 16;
    public static final int TIME_FRAME_FIXED = 0;
    public static final int TIME_FRAME_BACK_FROM_NOW = 1;
    public static final int TIME_UNIT_MINUTE = 0;
    public static final int TIME_UNIT_HOUR = 1;
    public static final int TIME_UNIT_DAY = 2;
    public static final int GF_AUTO_UPDATE = 1;
    public static final int GF_AUTO_SCALE = 256;
    public static final int GF_SHOW_GRID = 512;
    public static final int GF_SHOW_LEGEND = 1024;
    public static final int GF_SHOW_RULER = 2048;
    public static final int GF_SHOW_HOST_NAMES = 4096;
    public static final int GF_LOG_SCALE = 8192;
    public static final int GF_SHOW_TOOLTIPS = 16384;
    public static final int GF_ENABLE_ZOOM = 32768;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    public static final int POSITION_TOP = 4;
    public static final int POSITION_BOTTOM = 8;
    private long id;
    private long ownerId;
    private String name;
    private String shortName;
    private int flags;
    private int timeFrameType;
    private int timeUnit;
    private int timeFrame;
    private Date timeFrom;
    private Date timeTo;
    private int autoRefreshInterval;
    private int axisColor;
    private int backgroundColor;
    private int gridColor;
    private int selectionColor;
    private int textColor;
    private int rulerColor;
    private int legendPosition;
    private String title;
    private GraphItemStyle[] itemStyles = new GraphItemStyle[16];
    private GraphItem[] items;
    private List<AccessListElement> accessList;
    private Set<GraphSettingsChangeListener> changeListeners = new HashSet<GraphSettingsChangeListener>(0);

    public GraphSettings() {
        this.id = 0L;
        this.ownerId = 0L;
        this.name = "noname";
        this.shortName = "noname";
        this.flags = 50689;
        this.timeFrameType = 1;
        this.timeUnit = 0;
        this.timeFrame = 60;
        this.timeFrom = new Date();
        this.timeTo = new Date();
        this.autoRefreshInterval = 30000;
        this.axisColor = 0x161616;
        this.backgroundColor = 0xF0F0F0;
        this.gridColor = 0xE8E8E8;
        this.selectionColor = 0x800000;
        this.textColor = 0;
        this.rulerColor = 0;
        this.legendPosition = 8;
        this.title = "";
        this.items = new GraphItem[0];
        this.accessList = new ArrayList<AccessListElement>(0);
        for (int i = 0; i < this.itemStyles.length; ++i) {
            this.itemStyles[i] = new GraphItemStyle(0);
        }
    }

    public GraphSettings(NXCPMessage msg, long baseId) {
        this.id = msg.getVariableAsInt64(baseId);
        this.ownerId = msg.getVariableAsInt64(baseId + 1L);
        this.name = msg.getVariableAsString(baseId + 2L);
        this.legendPosition = 8;
        String[] parts = this.name.split("->");
        this.shortName = parts.length > 1 ? parts[parts.length - 1] : this.name;
        int count = msg.getVariableAsInteger(baseId + 4L);
        long[] users = msg.getVariableAsUInt32Array(baseId + 5L);
        long[] rights = msg.getVariableAsUInt32Array(baseId + 6L);
        this.accessList = new ArrayList<AccessListElement>(count);
        for (int i = 0; i < count; ++i) {
            this.accessList.add(new AccessListElement(users[i], (int)rights[i]));
        }
        this.parseGraphSettings(msg.getVariableAsString(baseId + 3L));
    }

    private void parseGraphSettings(String settings) {
        int dciCount = 0;
        this.flags = 0;
        for (int i = 0; i < 16; ++i) {
            this.itemStyles[i] = new GraphItemStyle();
        }
        String[] elements = settings.split("\u007f");
        for (int i = 0; i < elements.length; ++i) {
            int item;
            int index = elements[i].indexOf(58);
            if (index == -1) continue;
            String name = elements[i].substring(0, index);
            String value = elements[i].substring(index + 1);
            if (name.equals("A")) {
                this.autoRefreshInterval = GraphSettings.safeParseInt(value, 30) * 1000;
                continue;
            }
            if (name.equals("F")) {
                this.flags |= GraphSettings.safeParseInt(value, 0);
                continue;
            }
            if (name.equals("N")) {
                dciCount = GraphSettings.safeParseInt(value, 0);
                this.items = new GraphItem[dciCount];
                for (int j = 0; j < dciCount; ++j) {
                    this.items[j] = new GraphItem();
                }
                continue;
            }
            if (name.equals("TFT")) {
                this.timeFrameType = GraphSettings.safeParseInt(value, 1);
                continue;
            }
            if (name.equals("TU")) {
                this.timeUnit = GraphSettings.safeParseInt(value, 1);
                continue;
            }
            if (name.equals("NTU")) {
                this.timeFrame = GraphSettings.safeParseInt(value, 1);
                continue;
            }
            if (name.equals("TF")) {
                this.timeFrom = new Date((long)GraphSettings.safeParseInt(value, 0) * 1000L);
                continue;
            }
            if (name.equals("TF")) {
                this.timeTo = new Date((long)GraphSettings.safeParseInt(value, 0) * 1000L);
                continue;
            }
            if (name.equals("T")) {
                this.title = value;
                continue;
            }
            if (name.equals("S")) {
                if (GraphSettings.safeParseInt(value, 0) == 0) continue;
                this.flags |= 0x100;
                continue;
            }
            if (name.equals("G")) {
                if (GraphSettings.safeParseInt(value, 0) == 0) continue;
                this.flags |= 0x200;
                continue;
            }
            if (name.equals("L")) {
                if (GraphSettings.safeParseInt(value, 0) == 0) continue;
                this.flags |= 0x400;
                continue;
            }
            if (name.equals("R")) {
                if (GraphSettings.safeParseInt(value, 0) == 0) continue;
                this.flags |= 0x800;
                continue;
            }
            if (name.equals("H")) {
                if (GraphSettings.safeParseInt(value, 0) == 0) continue;
                this.flags |= 0x1000;
                continue;
            }
            if (name.equals("O")) {
                if (GraphSettings.safeParseInt(value, 0) == 0) continue;
                this.flags |= 0x2000;
                continue;
            }
            if (name.equals("CA")) {
                this.axisColor = GraphSettings.safeParseInt(value, 0);
                continue;
            }
            if (name.equals("CB")) {
                this.backgroundColor = GraphSettings.safeParseInt(value, 0);
                continue;
            }
            if (name.equals("CG")) {
                this.gridColor = GraphSettings.safeParseInt(value, 0);
                continue;
            }
            if (name.equals("CR")) {
                this.rulerColor = GraphSettings.safeParseInt(value, 0);
                continue;
            }
            if (name.equals("CS")) {
                this.selectionColor = GraphSettings.safeParseInt(value, 0);
                continue;
            }
            if (name.equals("CT")) {
                this.textColor = GraphSettings.safeParseInt(value, 0);
                continue;
            }
            if (name.charAt(0) == 'C') {
                item = GraphSettings.safeParseInt(name.substring(1), -1);
                if (item < 0 || item >= 16) continue;
                this.itemStyles[item].setColor(GraphSettings.safeParseInt(value, 0));
                continue;
            }
            if (name.charAt(0) == 'T') {
                item = GraphSettings.safeParseInt(name.substring(1), -1);
                if (item < 0 || item >= 16) continue;
                this.itemStyles[item].setColor(GraphSettings.safeParseInt(value, 0));
                continue;
            }
            if (name.charAt(0) == 'W') {
                item = GraphSettings.safeParseInt(name.substring(1), -1);
                if (item < 0 || item >= 16) continue;
                this.itemStyles[item].setLineWidth(GraphSettings.safeParseInt(value, 0));
                continue;
            }
            if (name.charAt(0) == 'F' && name.charAt(1) == 'L') {
                item = GraphSettings.safeParseInt(name.substring(2), -1);
                if (item < 0 || item >= 16) continue;
                this.itemStyles[item].setFlags(GraphSettings.safeParseInt(value, 0));
                continue;
            }
            if (name.charAt(0) == 'N') {
                item = GraphSettings.safeParseInt(name.substring(1), -1);
                if (item < 0 || item >= dciCount) continue;
                this.items[item].setNodeId(GraphSettings.safeParseLong(value, 0L));
                continue;
            }
            if (name.charAt(0) != 'I') continue;
            if (name.charAt(1) == 'D') {
                item = GraphSettings.safeParseInt(name.substring(2), -1);
                if (item < 0 || item >= dciCount) continue;
                this.items[item].setDescription(value);
                continue;
            }
            if (name.charAt(1) == 'N') {
                item = GraphSettings.safeParseInt(name.substring(2), -1);
                if (item < 0 || item >= dciCount) continue;
                this.items[item].setName(value);
                continue;
            }
            if (name.charAt(1) == 'S') {
                item = GraphSettings.safeParseInt(name.substring(2), -1);
                if (item < 0 || item >= dciCount) continue;
                this.items[item].setSource(GraphSettings.safeParseInt(value, 0));
                continue;
            }
            if (name.charAt(1) == 'T') {
                item = GraphSettings.safeParseInt(name.substring(2), -1);
                if (item < 0 || item >= dciCount) continue;
                this.items[item].setDataType(GraphSettings.safeParseInt(value, 0));
                continue;
            }
            item = GraphSettings.safeParseInt(name.substring(1), -1);
            if (item < 0 || item >= dciCount) continue;
            this.items[item].setDciId(GraphSettings.safeParseLong(value, 0L));
        }
    }

    private static int safeParseInt(String text, int defVal) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            return defVal;
        }
    }

    private static long safeParseLong(String text, long defVal) {
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException numberFormatException) {
            return defVal;
        }
    }

    public boolean isLogScale() {
        return (this.flags & 0x2000) != 0;
    }

    public void setLogScale(boolean enable) {
        this.flags = enable ? (this.flags |= 0x2000) : (this.flags &= 0xFFFFDFFF);
    }

    public boolean isAutoRefresh() {
        return (this.flags & 1) != 0;
    }

    public void setAutoRefresh(boolean enable) {
        this.flags = enable ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean isGridVisible() {
        return (this.flags & 0x200) != 0;
    }

    public void setGridVisible(boolean enable) {
        this.flags = enable ? (this.flags |= 0x200) : (this.flags &= 0xFFFFFDFF);
    }

    public boolean isHostNamesVisible() {
        return (this.flags & 0x1000) != 0;
    }

    public void setHostNamesVisible(boolean enable) {
        this.flags = enable ? (this.flags |= 0x1000) : (this.flags &= 0xFFFFEFFF);
    }

    public boolean isLegendVisible() {
        return (this.flags & 0x400) != 0;
    }

    public void setLegendVisible(boolean enable) {
        this.flags = enable ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
    }

    public boolean isTooltipsEnabled() {
        return (this.flags & 0x4000) != 0;
    }

    public void setTooltipsEnabled(boolean enable) {
        this.flags = enable ? (this.flags |= 0x4000) : (this.flags &= 0xFFFFBFFF);
    }

    public boolean isZoomEnabled() {
        return (this.flags & 0x8000) != 0;
    }

    public void setZoomEnabled(boolean enable) {
        this.flags = enable ? (this.flags |= 0x8000) : (this.flags &= 0xFFFF7FFF);
    }

    public boolean isAutoScale() {
        return (this.flags & 0x100) != 0;
    }

    public void setAutoScale(boolean enable) {
        this.flags = enable ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    public long getId() {
        return this.id;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    public String getName() {
        return this.name;
    }

    public List<AccessListElement> getAccessList() {
        return this.accessList;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getTimeFrameType() {
        return this.timeFrameType;
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public int getTimeFrame() {
        return this.timeFrame;
    }

    public Date getTimeFrom() {
        return this.timeFrom;
    }

    public Date getTimeTo() {
        return this.timeTo;
    }

    public int getAutoRefreshInterval() {
        return this.autoRefreshInterval;
    }

    public int getAxisColor() {
        return this.axisColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getGridColor() {
        return this.gridColor;
    }

    public int getSelectionColor() {
        return this.selectionColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public int getRulerColor() {
        return this.rulerColor;
    }

    public String getTitle() {
        return this.title;
    }

    public GraphItemStyle[] getItemStyles() {
        return this.itemStyles;
    }

    public GraphItem[] getItems() {
        return this.items;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setTimeFrameType(int timeFrameType) {
        this.timeFrameType = timeFrameType;
    }

    public void setTimeUnit(int timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setTimeFrame(int timeFrame) {
        this.timeFrame = timeFrame;
    }

    public void setTimeFrom(Date timeFrom) {
        this.timeFrom = timeFrom;
    }

    public void setTimeTo(Date timeTo) {
        this.timeTo = timeTo;
    }

    public void setAutoRefreshInterval(int autoRefreshInterval) {
        this.autoRefreshInterval = autoRefreshInterval;
    }

    public void setAxisColor(int axisColor) {
        this.axisColor = axisColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setGridColor(int gridColor) {
        this.gridColor = gridColor;
    }

    public void setSelectionColor(int selectionColor) {
        this.selectionColor = selectionColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setRulerColor(int rulerColor) {
        this.rulerColor = rulerColor;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setItemStyles(GraphItemStyle[] itemStyles) {
        this.itemStyles = itemStyles;
    }

    public void setItems(GraphItem[] items) {
        this.items = items;
    }

    public long getTimeRangeMillis() {
        switch (this.timeUnit) {
            case 0: {
                return (long)this.timeFrame * 60L * 1000L;
            }
            case 1: {
                return (long)this.timeFrame * 60L * 60L * 1000L;
            }
            case 2: {
                return (long)this.timeFrame * 24L * 60L * 60L * 1000L;
            }
        }
        return 0L;
    }

    public int getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(int legendPosition) {
        this.legendPosition = legendPosition;
    }

    public void addChangeListener(GraphSettingsChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(GraphSettingsChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void fireChangeNotification() {
        for (GraphSettingsChangeListener l : this.changeListeners) {
            l.onGraphSettingsChange(this);
        }
    }
}

