/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.log;

import java.util.HashSet;
import java.util.Set;
import org.netxms.base.NXCPMessage;

public class ColumnFilter {
    public static final int EQUALS = 0;
    public static final int RANGE = 1;
    public static final int SET = 2;
    public static final int LIKE = 3;
    public static final int AND = 0;
    public static final int OR = 1;
    private int type;
    private long rangeFrom;
    private long rangeTo;
    private long equalsTo;
    private String like;
    private HashSet<ColumnFilter> set;
    private int operation;

    public ColumnFilter(long value) {
        this.type = 0;
        this.equalsTo = value;
    }

    public ColumnFilter(long rangeFrom, long rangeTo) {
        this.type = 1;
        this.rangeFrom = rangeFrom;
        this.rangeTo = rangeTo;
    }

    public ColumnFilter(String value) {
        this.type = 3;
        this.like = value;
    }

    public ColumnFilter() {
        this.type = 2;
        this.set = new HashSet();
        this.operation = 0;
    }

    public void addSubFilter(ColumnFilter filter) {
        if (this.type == 2) {
            this.set.add(filter);
        }
    }

    int fillMessage(NXCPMessage msg, long baseId) {
        int varCount = 1;
        msg.setVariableInt16(baseId, this.type);
        switch (this.type) {
            case 0: {
                msg.setVariableInt64(baseId + 1L, this.equalsTo);
                ++varCount;
                break;
            }
            case 1: {
                msg.setVariableInt64(baseId + 1L, this.rangeFrom);
                msg.setVariableInt64(baseId + 2L, this.rangeTo);
                varCount += 2;
                break;
            }
            case 3: {
                msg.setVariable(baseId + 1L, this.like);
                ++varCount;
                break;
            }
            case 2: {
                msg.setVariableInt16(baseId + 1L, this.operation);
                msg.setVariableInt16(baseId + 2L, this.set.size());
                varCount += 2;
                long varId = baseId + 3L;
                for (ColumnFilter f : this.set) {
                    int count = f.fillMessage(msg, varId);
                    varId += (long)count;
                    varCount += count;
                }
                break;
            }
        }
        return varCount;
    }

    public long getRangeFrom() {
        return this.rangeFrom;
    }

    public void setRangeFrom(long rangeFrom) {
        this.rangeFrom = rangeFrom;
    }

    public long getRangeTo() {
        return this.rangeTo;
    }

    public void setRangeTo(long rangeTo) {
        this.rangeTo = rangeTo;
    }

    public long getEqualsTo() {
        return this.equalsTo;
    }

    public void setEqualsTo(long equalsTo) {
        this.equalsTo = equalsTo;
    }

    public String getLike() {
        return this.like;
    }

    public void setLike(String like) {
        this.like = like;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getType() {
        return this.type;
    }

    public Set<ColumnFilter> getSubFilters() {
        return this.set;
    }
}

