/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import org.netxms.base.NXCPMessage;

public class SnmpUsmCredential {
    private String name;
    private int authMethod;
    private int privMethod;
    private String authPassword;
    private String privPassword;

    public SnmpUsmCredential(NXCPMessage msg, long baseId) {
        this.name = msg.getVariableAsString(baseId);
        this.authMethod = msg.getVariableAsInteger(baseId + 1L);
        this.privMethod = msg.getVariableAsInteger(baseId + 2L);
        this.authPassword = msg.getVariableAsString(baseId + 3L);
        this.privPassword = msg.getVariableAsString(baseId + 4L);
    }

    public SnmpUsmCredential() {
        this.name = "";
        this.authMethod = 0;
        this.privMethod = 0;
        this.authPassword = "";
        this.privPassword = "";
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setVariable(baseId, this.name);
        msg.setVariableInt16(baseId + 1L, this.authMethod);
        msg.setVariableInt16(baseId + 2L, this.privMethod);
        msg.setVariable(baseId + 3L, this.authPassword);
        msg.setVariable(baseId + 4L, this.privPassword);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(int authMethod) {
        this.authMethod = authMethod;
    }

    public int getPrivMethod() {
        return this.privMethod;
    }

    public void setPrivMethod(int privMethod) {
        this.privMethod = privMethod;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public String getPrivPassword() {
        return this.privPassword;
    }

    public void setPrivPassword(String privPassword) {
        this.privPassword = privPassword;
    }
}

