/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.swtchart.Chart;
import org.swtchart.ITitle;
import org.swtchart.internal.ChartLayoutData;
import org.swtchart.internal.Util;

public class Title
extends Canvas
implements ITitle,
PaintListener {
    protected Chart chart;
    protected String text;
    protected boolean isVisible;
    private final Font defaultFont;
    private static final int DEFAULT_FONT_SIZE = 13;
    private static final int DEFAULT_FOREGROUND = 9;
    private static final String DEFAULT_TEXT = "";

    public Title(Chart parent, int style) {
        super((Composite)parent, style);
        this.chart = parent;
        this.text = DEFAULT_TEXT;
        this.isVisible = true;
        this.defaultFont = new Font((Device)Display.getDefault(), "Tahoma", 13, 1);
        this.setFont(this.defaultFont);
        this.setForeground(Display.getDefault().getSystemColor(9));
        this.addPaintListener(this);
    }

    @Override
    public void setText(String text) {
        this.text = text == null ? this.getDefaultText() : text;
        this.chart.updateLayout();
    }

    protected String getDefaultText() {
        return DEFAULT_TEXT;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            super.setFont(this.defaultFont);
        } else {
            super.setFont(font);
        }
        this.chart.updateLayout();
    }

    @Override
    public void setForeground(Color color) {
        if (color == null) {
            super.setForeground(Display.getDefault().getSystemColor(9));
        } else {
            super.setForeground(color);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (this.isVisible == isVisible) {
            return;
        }
        this.isVisible = isVisible;
        this.chart.updateLayout();
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    protected boolean isHorizontal() {
        return true;
    }

    public void updateLayoutData() {
        int height;
        int width;
        if (this.isVisible() && !this.text.trim().equals(DEFAULT_TEXT)) {
            Point p = Util.getExtentInGC(this.getFont(), this.text);
            width = p.x;
            height = p.y;
        } else {
            width = 0;
            height = 0;
        }
        if (this.isHorizontal()) {
            this.setLayoutData(new ChartLayoutData(width, height));
        } else {
            this.setLayoutData(new ChartLayoutData(height, width));
        }
    }

    public void dispose() {
        super.dispose();
        if (!this.defaultFont.isDisposed()) {
            this.defaultFont.dispose();
        }
    }

    public void paintControl(PaintEvent e) {
        if (this.text == null || this.text.equals(DEFAULT_TEXT) || !this.isVisible) {
            return;
        }
        int width = this.getSize().x;
        int height = this.getSize().y;
        GC gc = e.gc;
        gc.setForeground(this.getForeground());
        gc.setFont(this.getFont());
        if (this.isHorizontal()) {
            int textWidth = gc.textExtent((String)this.text).x;
            int x = (int)((double)width / 2.0 - (double)textWidth / 2.0);
            if (x < 0) {
                x = 0;
            }
            gc.drawString(this.text, x, 0, true);
        } else {
            int textWidth = gc.textExtent((String)this.text).x;
            int textHeight = gc.textExtent((String)this.text).y;
            Image image = new Image((Device)Display.getCurrent(), textWidth, textHeight);
            GC tmpGc = new GC((Drawable)image);
            tmpGc.setForeground(this.getForeground());
            tmpGc.setBackground(this.getBackground());
            tmpGc.setFont(this.getFont());
            tmpGc.drawText(this.text, 0, 0);
            Transform transform = new Transform(gc.getDevice());
            transform.translate(0.0f, (float)textWidth);
            transform.rotate(270.0f);
            gc.setTransform(transform);
            int y = (int)((double)height / 2.0 - (double)textWidth / 2.0);
            if (y < 0) {
                y = 0;
            }
            gc.drawImage(image, -y, 0);
            tmpGc.dispose();
            transform.dispose();
            image.dispose();
        }
    }
}

