/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.policymanager.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.PolicyGroup;
import org.netxms.client.objects.PolicyRoot;
import org.netxms.ui.eclipse.objectbrowser.dialogs.CreateObjectDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class CreatePolicyGroup
implements IObjectActionDelegate {
    private Shell shell;
    private GenericObject currentObject;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        final CreateObjectDialog dlg = new CreateObjectDialog(this.shell, "Policy Group");
        if (dlg.open() == 0) {
            new Job("Create policy group"){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status;
                    try {
                        NXCObjectCreationData cd = new NXCObjectCreationData(15, dlg.getObjectName(), CreatePolicyGroup.this.currentObject.getObjectId());
                        ((NXCSession)ConsoleSharedData.getSession()).createObject(cd);
                        status = Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        status = new Status(4, "org.netxms.ui.eclipse.policymanager", e instanceof NXCException ? ((NXCException)e).getErrorCode() : 0, "Cannot create policy group: " + e.getMessage(), (Throwable)e);
                    }
                    return status;
                }
            }.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TreeSelection) {
            this.currentObject = (GenericObject)((TreeSelection)selection).getFirstElement();
            action.setEnabled(this.currentObject instanceof PolicyRoot || this.currentObject instanceof PolicyGroup);
        }
    }
}

