/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.widgets.internal.LastValuesComparator;
import org.netxms.ui.eclipse.datacollection.widgets.internal.LastValuesLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class LastValuesView
extends Composite {
    public static final String JOB_FAMILY = "LastValuesViewJob";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_VALUE = 2;
    public static final int COLUMN_TIMESTAMP = 3;
    private final ViewPart viewPart;
    private Node node;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private SortableTableViewer dataViewer;
    private boolean autoRefreshEnabled = false;
    private int autoRefreshInterval = 30000;
    private Runnable refreshTimer;

    public LastValuesView(ViewPart viewPart, Composite parent, int style, Node _node, final String configPrefix) {
        super(parent, style);
        this.viewPart = viewPart;
        this.node = _node;
        final IDialogSettings ds = Activator.getDefault().getDialogSettings();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (LastValuesView.this.isDisposed()) {
                    return;
                }
                LastValuesView.this.getDataFromServer();
                LastValuesView.this.getDisplay().timerExec(LastValuesView.this.autoRefreshInterval, (Runnable)this);
            }
        };
        String[] names = new String[]{"ID", "Description", "Value", "Timestamp"};
        int[] widths = new int[]{70, 250, 150, 100};
        this.dataViewer = new SortableTableViewer((Composite)this, names, widths, 0, 1024, -1);
        this.dataViewer.setLabelProvider((IBaseLabelProvider)new LastValuesLabelProvider());
        this.dataViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataViewer.setComparator((ViewerComparator)new LastValuesComparator());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.dataViewer, (IDialogSettings)ds, (String)configPrefix);
        this.createPopupMenu();
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                LastValuesView.this.dataViewer.getControl().setBounds(LastValuesView.this.getClientArea());
            }
        });
        this.dataViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)LastValuesView.this.dataViewer, (IDialogSettings)ds, (String)configPrefix);
                ds.put(String.valueOf(configPrefix) + ".autoRefresh", LastValuesView.this.autoRefreshEnabled);
                ds.put(String.valueOf(configPrefix) + ".autoRefreshInterval", LastValuesView.this.autoRefreshEnabled);
            }
        });
        this.getDataFromServer();
        try {
            ds.getInt(String.valueOf(configPrefix) + ".autoRefreshInterval");
        }
        catch (NumberFormatException numberFormatException) {}
        this.setAutoRefreshEnabled(ds.getBoolean(String.valueOf(configPrefix) + ".autoRefresh"));
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                LastValuesView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.dataViewer.getControl());
        this.dataViewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.dataViewer);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void getDataFromServer() {
        if (this.node == null) {
            this.dataViewer.setInput((Object)new DciValue[0]);
            return;
        }
        ConsoleJob job = new ConsoleJob("Get DCI values for node " + this.node.getObjectName(), (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", JOB_FAMILY){

            protected String getErrorMessage() {
                return "Cannot get DCI values for node " + LastValuesView.this.node.getObjectName();
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final DciValue[] data = LastValuesView.this.session.getLastValues(LastValuesView.this.node.getObjectId());
                new UIJob("Update last values view"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        LastValuesView.this.dataViewer.setInput((Object)data);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setNode(Node _node) {
        this.node = _node;
        this.getDataFromServer();
    }

    public void refresh() {
        this.getDataFromServer();
    }

    public boolean isAutoRefreshEnabled() {
        return this.autoRefreshEnabled;
    }

    public void setAutoRefreshEnabled(boolean autoRefreshEnabled) {
        this.autoRefreshEnabled = autoRefreshEnabled;
        this.getDisplay().timerExec(autoRefreshEnabled ? this.autoRefreshInterval : -1, this.refreshTimer);
    }

    public int getAutoRefreshInterval() {
        return this.autoRefreshInterval;
    }

    public void setAutoRefreshInterval(int autoRefreshInterval) {
        this.autoRefreshInterval = autoRefreshInterval;
    }
}

