/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ZoneSelectionDialog
extends Dialog {
    private ObjectSelector objectSelector;
    private long zoneId;

    public ZoneSelectionDialog(Shell parent) {
        super(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Zone");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0);
        this.objectSelector.setLabel("Zone object");
        this.objectSelector.setObjectClass(6);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.objectSelector.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        long objectId = this.objectSelector.getObjectId();
        if (objectId == 0L) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select zone object!");
            return;
        }
        GenericObject object = ((NXCSession)ConsoleSharedData.getSession()).findObjectById(objectId);
        if (object == null || !(object instanceof Zone)) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select zone object!");
            return;
        }
        this.zoneId = ((Zone)object).getZoneId();
        super.okPressed();
    }

    public long getZoneId() {
        return this.zoneId;
    }
}

