/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.ui.eclipse.filemanager.dialogs.StartFileUploadDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class UploadFileToAgent
implements IObjectActionDelegate {
    private Shell shell;
    private ViewPart viewPart;
    private Set<Long> nodes = new HashSet<Long>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }

    public void run(IAction action) {
        final StartFileUploadDialog dlg = new StartFileUploadDialog(this.shell);
        if (dlg.open() == 0) {
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            final Long[] nodeIdList = this.nodes.toArray(new Long[this.nodes.size()]);
            new ConsoleJob("Initiate file upload to agent", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.filemanager", null){

                protected String getErrorMessage() {
                    return "Cannot start file upload job";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    int i = 0;
                    while (i < nodeIdList.length) {
                        session.uploadFileToAgent(nodeIdList[i].longValue(), dlg.getServerFile().getName(), dlg.getRemoteFileName(), dlg.isCreateJobOnHold());
                        ++i;
                    }
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.nodes.clear();
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        for (Object object : (IStructuredSelection)selection) {
            if (object instanceof Node) {
                this.nodes.add(((Node)object).getObjectId());
                continue;
            }
            if (!(object instanceof Container) && !(object instanceof ServiceRoot) && !(object instanceof Subnet) && !(object instanceof EntireNetwork)) continue;
            Set set = ((GenericObject)object).getAllChilds(2);
            for (GenericObject o : set) {
                this.nodes.add(o.getObjectId());
            }
        }
        action.setEnabled(this.nodes.size() > 0);
    }
}

