/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.actions;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.views.VlanView;

public class ShowVlans
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private long objectId;

    public void run(IAction action) {
        IViewReference vr = this.window.getActivePage().findViewReference("org.netxms.ui.eclipse.topology.views.VlanView", Long.toString(this.objectId));
        if (vr != null) {
            VlanView view = (VlanView)vr.getView(true);
            if (view != null) {
                this.window.getActivePage().activate((IWorkbenchPart)view);
            }
        } else {
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            new ConsoleJob("Reading VLAN list from node", null, "org.netxms.ui.eclipse.topology", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    final List vlans = session.getVlans(ShowVlans.this.objectId);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                VlanView view = (VlanView)ShowVlans.this.window.getActivePage().showView("org.netxms.ui.eclipse.topology.views.VlanView", Long.toString(ShowVlans.this.objectId), 1);
                                view.setVlans(vlans);
                            }
                            catch (PartInitException e) {
                                MessageDialog.openError((Shell)ShowVlans.this.window.getShell(), (String)"Error", (String)("Cannot open VLAN view: " + e.getLocalizedMessage()));
                            }
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Cannot get VLAN list from node";
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof Node) {
                action.setEnabled(true);
                this.objectId = ((GenericObject)obj).getObjectId();
            } else {
                action.setEnabled(false);
                this.objectId = 0L;
            }
        } else {
            action.setEnabled(false);
            this.objectId = 0L;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }
}

