/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.topology.VlanInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.views.helpers.VlanLabelProvider;
import org.netxms.ui.eclipse.topology.widgets.DeviceView;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class VlanView
extends ViewPart
implements ISelectionChangedListener {
    public static final String ID = "org.netxms.ui.eclipse.topology.views.VlanView";
    public static final int COLUMN_VLAN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_PORTS = 2;
    private long nodeId;
    private List<VlanInfo> vlans = new ArrayList<VlanInfo>(0);
    private NXCSession session;
    private SortableTableViewer vlanList;
    private DeviceView deviceView;
    private Action actionShowVlanMap;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.nodeId = Long.parseLong(site.getSecondaryId());
        this.session = (NXCSession)ConsoleSharedData.getSession();
        GenericObject object = this.session.findObjectById(this.nodeId);
        this.setPartName("VLAN View - " + (object != null ? object.getObjectName() : "<" + site.getSecondaryId() + ">"));
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        String[] names = new String[]{"ID", "Name", "Ports"};
        int[] widths = new int[]{80, 180, 400};
        this.vlanList = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.vlanList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.vlanList.setLabelProvider((IBaseLabelProvider)new VlanLabelProvider());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.vlanList.getTable().setLayoutData((Object)gd);
        this.vlanList.setInput((Object)this.vlans.toArray());
        this.vlanList.addSelectionChangedListener((ISelectionChangedListener)this);
        this.deviceView = new DeviceView(parent, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.deviceView.setLayoutData(gd);
        this.deviceView.setPortStatusVisible(false);
        this.deviceView.setNodeId(this.nodeId);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionShowVlanMap = new Action("Show VLAN map"){

            public void run() {
                VlanView.this.showVlanMap();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowVlanMap);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                VlanView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.vlanList.getControl());
        this.vlanList.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.vlanList);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowVlanMap);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.vlanList.getControl().setFocus();
    }

    public void setVlans(List<VlanInfo> vlans) {
        this.vlans = vlans;
        this.vlanList.setInput((Object)vlans.toArray());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.vlanList.getSelection();
        VlanInfo vlan = (VlanInfo)selection.getFirstElement();
        if (vlan != null) {
            this.deviceView.setHighlight(vlan.getPorts());
        } else {
            this.deviceView.clearHighlight(true);
        }
    }

    private void showVlanMap() {
        IStructuredSelection selection = (IStructuredSelection)this.vlanList.getSelection();
        IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
        for (Object o : selection.toList()) {
            VlanInfo vlan = (VlanInfo)o;
            try {
                page.showView("org.netxms.ui.eclipse.networkmaps.views.VlanMap", String.valueOf(Long.toString(this.nodeId)) + "&" + Integer.toString(vlan.getVlanId()), 1);
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Cannot open VLAN map view for VLAN " + vlan.getVlanId() + ": " + e.getLocalizedMessage()));
            }
        }
    }
}

