/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.netxms.api.client.Session;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LoginJob
implements IRunnableWithProgress {
    private String server;
    private String loginName;
    private String password;

    public LoginJob(String server, String loginName, String password) {
        this.server = server;
        this.loginName = loginName;
        this.password = password;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(Messages.getString("LoginJob.connecting"), 100);
        try {
            try {
                String hostName;
                int port = 4701;
                String[] split = this.server.split(":");
                if (split.length == 2) {
                    hostName = split[0];
                    try {
                        port = Integer.valueOf(split[1]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    hostName = this.server;
                }
                NXCSession session = new NXCSession(hostName, port, this.loginName, this.password);
                monitor.worked(10);
                session.connect();
                monitor.worked(40);
                monitor.setTaskName(Messages.getString("LoginJob.sync_objects"));
                session.syncObjects();
                monitor.worked(25);
                monitor.setTaskName(Messages.getString("LoginJob.sync_users"));
                session.syncUserDatabase();
                monitor.worked(5);
                monitor.setTaskName(Messages.getString("LoginJob.sync_event_db"));
                session.syncEventTemplates();
                monitor.worked(5);
                monitor.setTaskName(Messages.getString("LoginJob.subscribe"));
                session.subscribe(13);
                monitor.worked(5);
                ConsoleSharedData.setSession((Session)session);
                KeepAliveHelper keepAliveTimer = new KeepAliveHelper();
                Thread thread = new Thread(keepAliveTimer);
                thread.setDaemon(true);
                thread.start();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private final class KeepAliveHelper
    implements Runnable {
        private KeepAliveHelper() {
        }

        @Override
        public void run() {
            Session session = ConsoleSharedData.getSession();
            try {
                session.checkConnection();
                Thread.sleep(30000L);
            }
            catch (Exception exception) {}
        }
    }
}

