/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.widgets;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.GeoLocation;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.osm.GeoLocationCache;
import org.netxms.ui.eclipse.osm.GeoLocationCacheListener;
import org.netxms.ui.eclipse.osm.tools.Area;
import org.netxms.ui.eclipse.osm.tools.MapAccessor;
import org.netxms.ui.eclipse.widgets.AnimatedImage;

public class GeoMapViewer
extends Canvas
implements PaintListener,
GeoLocationCacheListener {
    private static final Color MAP_BACKGROUND = new Color((Device)Display.getDefault(), 255, 255, 255);
    private static final Color INFO_BLOCK_BACKGROUND = new Color((Device)Display.getDefault(), 150, 240, 88);
    private static final Color INFO_BLOCK_BORDER = new Color((Device)Display.getDefault(), 0, 0, 0);
    private static final Color INFO_BLOCK_TEXT = new Color((Device)Display.getDefault(), 0, 0, 0);
    private static final Color LABEL_BACKGROUND = new Color((Device)Display.getDefault(), 240, 254, 192);
    private static final Color LABEL_BORDER = new Color((Device)Display.getDefault(), 0, 0, 0);
    private static final int LABEL_ARROW_HEIGHT = 20;
    private static final int LABEL_ARROW_OFFSET = 10;
    private static final int LABEL_X_MARGIN = 4;
    private static final int LABEL_Y_MARGIN = 4;
    private static final int LABEL_SPACING = 4;
    private String imageAccessSync = "SYNC";
    private ILabelProvider labelProvider;
    private Image currentImage = null;
    private Area coverage = null;
    private List<GenericObject> objects = new ArrayList<GenericObject>();
    private MapAccessor accessor;
    private IWorkbenchSiteProgressService siteService = null;
    private GenericObject centerMarker = null;
    private AnimatedImage waitingImage = null;

    public GeoMapViewer(Composite parent, int style) {
        super(parent, style);
        this.labelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
        this.setBackground(MAP_BACKGROUND);
        this.addPaintListener(this);
        final Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (GeoMapViewer.this.isDisposed()) {
                    return;
                }
                GeoMapViewer.this.reloadMap();
            }
        };
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GeoMapViewer.this.getDisplay().timerExec(1000, timer);
                Rectangle rect = GeoMapViewer.this.getClientArea();
                Point size = GeoMapViewer.this.waitingImage.getSize();
                GeoMapViewer.this.waitingImage.setLocation(rect.x + rect.width / 2 - size.x, rect.y + rect.height / 2 - size.y);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GeoMapViewer.this.labelProvider.dispose();
                GeoLocationCache.getInstance().removeListener(GeoMapViewer.this);
            }
        });
        this.waitingImage = new AnimatedImage((Composite)this, 0);
        this.waitingImage.setVisible(false);
        GeoLocationCache.getInstance().addListener(this);
    }

    public void showMap(MapAccessor accessor) {
        this.accessor = new MapAccessor(accessor);
        this.reloadMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadMap() {
        Rectangle rect = this.getClientArea();
        this.accessor.setMapWidth(rect.width);
        this.accessor.setMapHeight(rect.height);
        String string = this.imageAccessSync;
        synchronized (string) {
            if (this.currentImage != null) {
                this.currentImage.dispose();
            }
            this.currentImage = null;
        }
        this.redraw();
        this.waitingImage.setVisible(true);
        try {
            this.waitingImage.setImage(new URL("platform:/plugin/org.netxms.ui.eclipse.library/icons/loading.gif"));
        }
        catch (MalformedURLException malformedURLException) {}
        if (!this.accessor.isValid()) {
            return;
        }
        URL url = null;
        try {
            url = new URL(this.accessor.generateUrl());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("URL: " + url.toString());
        final ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
        Job job = new Job("Download map image"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                Image image = id.createImage();
                String string = GeoMapViewer.this.imageAccessSync;
                synchronized (string) {
                    if (GeoMapViewer.this.currentImage != null) {
                        GeoMapViewer.this.currentImage.dispose();
                    }
                    GeoMapViewer.this.currentImage = image;
                }
                new UIJob("Redraw map"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        Point mapSize = new Point(((GeoMapViewer)(this).GeoMapViewer.this).currentImage.getImageData().width, ((GeoMapViewer)(this).GeoMapViewer.this).currentImage.getImageData().height);
                        GeoMapViewer.this.coverage = GeoLocationCache.calculateCoverage(mapSize, GeoMapViewer.this.accessor.getCenterPoint(), GeoMapViewer.this.accessor.getZoom());
                        GeoMapViewer.this.objects = GeoLocationCache.getInstance().getObjectsInArea(GeoMapViewer.this.coverage);
                        GeoMapViewer.this.waitingImage.setImage(null);
                        GeoMapViewer.this.waitingImage.setVisible(false);
                        GeoMapViewer.this.redraw();
                        return Status.OK_STATUS;
                    }
                }.schedule();
                return Status.OK_STATUS;
            }
        };
        if (this.siteService != null) {
            this.siteService.schedule(job, 0L, true);
        } else {
            job.schedule();
        }
    }

    public IWorkbenchSiteProgressService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(IWorkbenchSiteProgressService siteService) {
        this.siteService = siteService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintControl(PaintEvent e) {
        int imgH;
        int imgW;
        GC gc = e.gc;
        String string = this.imageAccessSync;
        synchronized (string) {
            if (this.currentImage != null) {
                gc.drawImage(this.currentImage, 0, 0);
                imgW = this.currentImage.getImageData().width;
                imgH = this.currentImage.getImageData().height;
            } else {
                imgW = -1;
                imgH = -1;
            }
        }
        Point centerXY = GeoLocationCache.coordinateToDisplay(this.accessor.getCenterPoint(), this.accessor.getZoom());
        for (GenericObject object : this.objects) {
            Point virtualXY = GeoLocationCache.coordinateToDisplay(object.getGeolocation(), this.accessor.getZoom());
            int dx = virtualXY.x - centerXY.x;
            int dy = virtualXY.y - centerXY.y;
            this.drawObject(gc, imgW / 2 + dx, imgH / 2 + dy, object);
        }
        GeoLocation gl = new GeoLocation(this.accessor.getLatitude(), this.accessor.getLongitude());
        String text = gl.toString();
        Point textSize = gc.textExtent(text);
        Rectangle rect = this.getClientArea();
        rect.x = 10;
        rect.y += 10;
        rect.width = textSize.x + 10;
        rect.height = textSize.y + 8;
        gc.setAntialias(1);
        gc.setBackground(INFO_BLOCK_BACKGROUND);
        gc.setAlpha(192);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.setAlpha(255);
        gc.setForeground(INFO_BLOCK_BORDER);
        gc.setLineWidth(1);
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.setForeground(INFO_BLOCK_TEXT);
        gc.drawText(text, rect.x + 5, rect.y + 4, true);
    }

    private void drawObject(GC gc, int x, int y, GenericObject object) {
        String text = object.getObjectName();
        Image image = this.labelProvider.getImage((Object)object);
        Point textSize = gc.textExtent(text);
        Rectangle rect = new Rectangle(x - 10, y - 20 - textSize.y, textSize.x + image.getImageData().width + 8 + 4, Math.max(image.getImageData().height, textSize.y) + 8);
        gc.setBackground(LABEL_BACKGROUND);
        gc.setForeground(LABEL_BORDER);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        int[] arrow = new int[]{rect.x + 10 - 4, rect.y + rect.height, x, y, rect.x + 10 + 4, rect.y + rect.height};
        gc.fillPolygon(arrow);
        gc.setForeground(LABEL_BACKGROUND);
        gc.drawLine(arrow[0], arrow[1], arrow[4], arrow[5]);
        gc.setForeground(LABEL_BORDER);
        gc.drawPolyline(arrow);
        gc.drawImage(image, rect.x + 4, rect.y + 4);
        gc.drawText(text, rect.x + 4 + image.getImageData().width + 4, rect.y + 4);
    }

    public GenericObject getCenterMarker() {
        return this.centerMarker;
    }

    public void setCenterMarker(GenericObject centerMarker) {
        this.centerMarker = centerMarker;
    }

    @Override
    public void geoLocationCacheChanged(final GenericObject object, final GeoLocation prevLocation) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GeoMapViewer.this.onCacheChange(object, prevLocation);
            }
        });
    }

    private void onCacheChange(GenericObject object, GeoLocation prevLocation) {
        GeoLocation currLocation = object.getGeolocation();
        if (currLocation.getType() != 0 && this.coverage.contains(currLocation.getLatitude(), currLocation.getLongitude()) || prevLocation != null && prevLocation.getType() != 0 && this.coverage.contains(prevLocation.getLatitude(), prevLocation.getLongitude())) {
            this.objects = GeoLocationCache.getInstance().getObjectsInArea(this.coverage);
            this.redraw();
        }
    }
}

