/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectAdapterFactory
implements IAdapterFactory {
    private static final Class[] supportedClasses = new Class[]{IWorkbenchAdapter.class};
    private boolean showComments = Activator.getDefault().getPreferenceStore().getBoolean("SHOW_COMMENTS");

    public Class[] getAdapterList() {
        return supportedClasses;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IWorkbenchAdapter.class && adaptableObject instanceof GenericObject) {
            return new IWorkbenchAdapter(){

                public Object[] getChildren(Object o) {
                    return ((GenericObject)o).getChildsAsArray();
                }

                public ImageDescriptor getImageDescriptor(Object object) {
                    switch (((GenericObject)object).getObjectClass()) {
                        case 4: {
                            return Activator.getImageDescriptor("icons/network.png");
                        }
                        case 7: {
                            return Activator.getImageDescriptor("icons/service_root.png");
                        }
                        case 5: {
                            return Activator.getImageDescriptor("icons/container.png");
                        }
                        case 6: {
                            return Activator.getImageDescriptor("icons/zone.gif");
                        }
                        case 1: {
                            return Activator.getImageDescriptor("icons/subnet.png");
                        }
                        case 14: {
                            return Activator.getImageDescriptor("icons/cluster.png");
                        }
                        case 2: {
                            return Activator.getImageDescriptor("icons/node.png");
                        }
                        case 3: {
                            return Activator.getImageDescriptor("icons/interface.png");
                        }
                        case 13: {
                            return Activator.getImageDescriptor("icons/condition.gif");
                        }
                        case 10: {
                            return Activator.getImageDescriptor("icons/template_root.png");
                        }
                        case 9: {
                            return Activator.getImageDescriptor("icons/template_group.png");
                        }
                        case 8: {
                            return Activator.getImageDescriptor("icons/template.png");
                        }
                        case 16: {
                            return Activator.getImageDescriptor("icons/policy_root.gif");
                        }
                        case 15: {
                            return Activator.getImageDescriptor("icons/policy_group.png");
                        }
                        case 17: 
                        case 18: {
                            return Activator.getImageDescriptor("icons/policy.png");
                        }
                        case 21: {
                            return Activator.getImageDescriptor("icons/netmap.png");
                        }
                        case 20: {
                            return Activator.getImageDescriptor("icons/netmap_group.png");
                        }
                        case 19: {
                            return Activator.getImageDescriptor("icons/netmap_root.gif");
                        }
                        case 23: {
                            return Activator.getImageDescriptor("icons/dashboard.gif");
                        }
                        case 22: {
                            return Activator.getImageDescriptor("icons/dashboard_root.gif");
                        }
                    }
                    return null;
                }

                public String getLabel(Object o) {
                    String s;
                    String comments;
                    if (ObjectAdapterFactory.this.showComments && (comments = ((GenericObject)o).getComments()) != null && (s = comments.replace("\r", "").replace("\n", " ").trim()).length() > 0) {
                        return String.valueOf(((GenericObject)o).getObjectName()) + " [" + (s.length() > 100 ? s.substring(0, 100) : s) + "]";
                    }
                    return ((GenericObject)o).getObjectName();
                }

                public Object getParent(Object o) {
                    NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                    if (session != null) {
                        Iterator it = ((GenericObject)o).getParents();
                        return it.hasNext() ? session.findObjectById(((Long)it.next()).longValue()) : null;
                    }
                    return null;
                }
            };
        }
        return null;
    }
}

