/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectToolsAdapterFactory
implements IAdapterFactory {
    private static final Class[] supportedClasses = new Class[]{IWorkbenchAdapter.class, ObjectToolDetails.class};
    private static Map<Long, ObjectToolDetails> cache = new HashMap<Long, ObjectToolDetails>();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject.getClass() != ObjectTool.class) {
            return null;
        }
        if (adapterType == ObjectToolDetails.class) {
            long toolId = ((ObjectTool)adaptableObject).getId();
            ObjectToolDetails details = cache.get(toolId);
            if (details == null) {
                ToolDetailLoader job = new ToolDetailLoader(toolId);
                IProgressService service = PlatformUI.getWorkbench().getProgressService();
                try {
                    service.busyCursorWhile((IRunnableWithProgress)job);
                    details = job.getResult();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return details;
        }
        if (adapterType == IWorkbenchAdapter.class) {
            return new IWorkbenchAdapter(){

                public Object getParent(Object o) {
                    return null;
                }

                public String getLabel(Object o) {
                    return ((ObjectTool)o).getDisplayName();
                }

                public ImageDescriptor getImageDescriptor(Object object) {
                    return null;
                }

                public Object[] getChildren(Object o) {
                    return null;
                }
            };
        }
        return null;
    }

    public Class[] getAdapterList() {
        return supportedClasses;
    }

    public static ObjectToolDetails getDetailsFromCache(long toolId) {
        return cache.get(toolId);
    }

    public static void deleteFromCache(long toolId) {
        cache.remove(toolId);
    }

    public static void clearCache() {
        cache.clear();
    }

    private final class ToolDetailLoader
    implements IRunnableWithProgress {
        private final long toolId;
        private ObjectToolDetails result = null;

        private ToolDetailLoader(long toolId) {
            this.toolId = toolId;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            try {
                this.result = session.getObjectToolDetails(this.toolId);
                new UIJob("Update object tool adapter cache"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        cache.put(ToolDetailLoader.this.toolId, ToolDetailLoader.this.result);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            catch (Exception e) {
                new UIJob("Show error message"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)("Cannot load object tool details: " + e.getLocalizedMessage()));
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }

        public ObjectToolDetails getResult() {
            return this.result;
        }
    }
}

