/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.objecttools.Activator;

public class ObjectToolsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String[] toolTypes = new String[]{"Internal", "Action", "SNMP Table", "Agent Table", "URL", "Local Command", "Server Command"};
    private Image[] toolTypeImages = new Image[7];

    public ObjectToolsLabelProvider() {
        this.toolTypeImages[0] = Activator.getImageDescriptor("icons/internal_tool.gif").createImage();
        this.toolTypeImages[1] = Activator.getImageDescriptor("icons/agent_action.gif").createImage();
        this.toolTypeImages[2] = Activator.getImageDescriptor("icons/table.gif").createImage();
        this.toolTypeImages[3] = Activator.getImageDescriptor("icons/table.gif").createImage();
        this.toolTypeImages[4] = Activator.getImageDescriptor("icons/url.gif").createImage();
        this.toolTypeImages[5] = Activator.getImageDescriptor("icons/console.png").createImage();
        this.toolTypeImages[6] = Activator.getImageDescriptor("icons/console.png").createImage();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        try {
            return this.toolTypeImages[((ObjectTool)element).getType()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public String getColumnText(Object element, int columnIndex) {
        ObjectTool tool = (ObjectTool)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(tool.getId());
            }
            case 1: {
                return tool.getName();
            }
            case 2: {
                try {
                    return toolTypes[tool.getType()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return "?unknown?";
                }
            }
            case 3: {
                return tool.getDescription();
            }
        }
        return null;
    }

    public void dispose() {
        Image[] imageArray = this.toolTypeImages;
        int n = this.toolTypeImages.length;
        int n2 = 0;
        while (n2 < n) {
            Image i = imageArray[n2];
            i.dispose();
            ++n2;
        }
        super.dispose();
    }

    public static String getToolTypeName(ObjectTool tool) {
        try {
            return toolTypes[tool.getType()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "?unknown?";
        }
    }

    public static String[] getAllToolTypes() {
        return toolTypes;
    }
}

