/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.objecttabs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.PerfTabDci;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.charts.PerfTabGraphSettings;
import org.netxms.ui.eclipse.charts.objecttabs.internal.PerfTabGraph;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class PerformanceTab
extends ObjectTab {
    private List<PerfTabGraph> charts = new ArrayList<PerfTabGraph>();
    private ScrolledComposite scroller;
    private Composite chartArea;
    private Label labelLoading = null;

    protected void createTabContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 512);
        this.chartArea = new Composite((Composite)this.scroller, 0);
        this.chartArea.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        this.chartArea.setLayout((Layout)layout);
        this.scroller.setContent((Control)this.chartArea);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        this.scroller.getVerticalBar().setIncrement(20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = PerformanceTab.this.scroller.getClientArea();
                PerformanceTab.this.scroller.setMinSize(PerformanceTab.this.chartArea.computeSize(r.width, -1));
            }
        });
    }

    public void objectChanged(final GenericObject object) {
        for (PerfTabGraph chart : this.charts) {
            chart.dispose();
        }
        if (this.labelLoading == null || this.labelLoading.isDisposed()) {
            this.labelLoading = new Label(this.chartArea, 0);
            this.labelLoading.setText("Loading performance data...");
        }
        Job job = new Job("Update performance tab"){

            protected IStatus run(IProgressMonitor monitor) {
                NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                try {
                    final PerfTabDci[] items = session.getPerfTabItems(object.getObjectId());
                    new UIJob("Update performance tab"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (PerformanceTab.this.getObject().getObjectId() == object.getObjectId()) {
                                PerformanceTab.this.update(items);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                catch (Exception exception) {}
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void update(PerfTabDci[] items) {
        this.labelLoading.dispose();
        int i = 0;
        while (i < items.length) {
            try {
                PerfTabGraphSettings settings = PerfTabGraphSettings.createFromXml(items[i].getPerfTabSettings());
                PerfTabGraph chart = new PerfTabGraph(this.chartArea, this.getObject().getObjectId(), items[i], settings);
                this.charts.add(chart);
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.heightHint = 250;
                chart.setLayoutData(gd);
            }
            catch (Exception exception) {}
            ++i;
        }
        this.updateChartAreaLayout();
    }

    private void updateChartAreaLayout() {
        this.chartArea.layout();
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.chartArea.computeSize(r.width, -1));
    }

    public boolean showForObject(GenericObject object) {
        return object instanceof Node;
    }
}

