/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.ui.eclipse.charts.PerfTabGraphSettings;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class PerfTab
extends PropertyPage {
    private DataCollectionItem dci;
    private PerfTabGraphSettings settings;
    private Button checkShow;
    private LabeledText title;
    private ColorSelector color;
    private Button checkShowThresholds;

    protected Control createContents(Composite parent) {
        this.dci = (DataCollectionItem)this.getElement().getAdapter(DataCollectionItem.class);
        try {
            this.settings = PerfTabGraphSettings.createFromXml(this.dci.getPerfTabSettings());
        }
        catch (Exception exception) {
            this.settings = new PerfTabGraphSettings();
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.checkShow = new Button(dialogArea, 32);
        this.checkShow.setText("&Show on performance tab");
        this.checkShow.setSelection(this.settings.isEnabled());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.checkShow.setLayoutData((Object)gd);
        this.title = new LabeledText(dialogArea, 0);
        this.title.setLabel("Title");
        this.title.setText(this.settings.getTitle());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.title.setLayoutData((Object)gd);
        Composite colors = new Composite(dialogArea, 0);
        colors.setLayout((Layout)new RowLayout(512));
        new Label(colors, 0).setText("Color");
        this.color = new ColorSelector(colors);
        this.color.setColorValue(ColorConverter.rgbFromInt((int)this.settings.getColorAsInt()));
        this.checkShowThresholds = new Button(dialogArea, 32);
        this.checkShowThresholds.setText("&Show thresholds on graph");
        this.checkShowThresholds.setSelection(this.settings.isShowThresholds());
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.checkShowThresholds.setLayoutData((Object)gd);
        return dialogArea;
    }

    private void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        this.settings.setEnabled(this.checkShow.getSelection());
        this.settings.setTitle(this.title.getText());
        this.settings.setColor(ColorConverter.rgbToInt((RGB)this.color.getColorValue()));
        this.settings.setShowThresholds(this.checkShowThresholds.getSelection());
        try {
            this.dci.setPerfTabSettings(this.settings.createXml());
        }
        catch (Exception exception) {
            this.dci.setPerfTabSettings(null);
        }
        ConsoleJob job = new ConsoleJob("Update performance tab settings for DCI " + this.dci.getId(), null, "org.netxms.ui.eclipse.charts", null){

            protected String getErrorMessage() {
                return "Cannot update performance tab settings for DCI " + PerfTab.this.dci.getId();
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PerfTab.this.dci.getOwner().modifyItem(PerfTab.this.dci);
            }

            protected void jobFinalize() {
                if (isApply) {
                    new UIJob("Update \"Performance Tab\" property page"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            PerfTab.this.setValid(true);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        };
        job.start();
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        PerfTabGraphSettings defaults = new PerfTabGraphSettings();
        this.checkShow.setSelection(defaults.isEnabled());
        this.title.setText(defaults.getTitle());
        this.color.setColorValue(ColorConverter.rgbFromInt((int)defaults.getColorAsInt()));
    }
}

