/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class Transformation
extends PropertyPage {
    private static final String[] DCI_FUNCTIONS = new String[]{"FindDCIByName", "FindDCIByDescription", "GetDCIObject", "GetDCIValue"};
    private static final String[] DCI_VARIABLES = new String[]{"$node"};
    private DataCollectionItem dci;
    private Combo deltaCalculation;
    private ScriptEditor transformationScript;
    private Button testScriptButton;

    protected Control createContents(Composite parent) {
        this.dci = (DataCollectionItem)this.getElement().getAdapter(DataCollectionItem.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.deltaCalculation = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)"Step 1 - delta calculation", (Object)"WidgetHelper::default_layout_data");
        this.deltaCalculation.add("None (keep original value)");
        this.deltaCalculation.add("Simple delta");
        this.deltaCalculation.add("Average delta per second");
        this.deltaCalculation.add("Average delta per minute");
        this.deltaCalculation.select(this.dci.getDeltaCalculation());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 0;
        gd.heightHint = 0;
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new ScriptEditor(parent, style, 768);
            }
        };
        this.transformationScript = (ScriptEditor)WidgetHelper.createLabeledControl((Composite)dialogArea, (int)2048, (WidgetFactory)factory, (String)"Step 2 - transformation script", (Object)gd);
        this.transformationScript.addFunctions(Arrays.asList(DCI_FUNCTIONS));
        this.transformationScript.addVariables(Arrays.asList(DCI_VARIABLES));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.transformationScript.setLayoutData((Object)gd);
        this.transformationScript.setText(this.dci.getTransformationScript());
        this.testScriptButton = new Button(this.transformationScript.getParent(), 8);
        this.testScriptButton.setText("&Test...");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 90;
        this.testScriptButton.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        this.dci.setDeltaCalculation(this.deltaCalculation.getSelectionIndex());
        this.dci.setTransformationScript(this.transformationScript.getText());
        new ConsoleJob("Update transformation settings for DCI " + this.dci.getId(), null, "org.netxms.ui.eclipse.datacollection", null){

            protected String getErrorMessage() {
                return "Cannot update transformation settings";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Transformation.this.dci.getOwner().modifyItem(Transformation.this.dci);
                new UIJob("Update data collection item list"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ((TableViewer)Transformation.this.dci.getOwner().getUserData()).update((Object)Transformation.this.dci, null);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            protected void jobFinalize() {
                if (isApply) {
                    new UIJob("Update \"Transformation\" property page"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            Transformation.this.setValid(true);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.deltaCalculation.select(0);
        this.transformationScript.setText("");
    }
}

