/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.datacollection.widgets.LastValuesView;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LastValues
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.datacollection.view.last_values";
    private NXCSession session;
    private Node node;
    private LastValuesView dataView;
    private Action actionRefresh;
    private Action actionAutoUpdate;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        GenericObject obj = this.session.findObjectById(Long.parseLong(site.getSecondaryId()));
        this.node = obj != null && obj instanceof Node ? (Node)obj : null;
        this.setPartName("Last Values - " + (this.node != null ? this.node.getObjectName() : "<error>"));
    }

    public void createPartControl(Composite parent) {
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        this.dataView = new LastValuesView(this, parent, 0, this.node, "LastValuesView");
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.dataView.setLayoutData(fd);
        this.createActions();
        this.contributeToActionBars();
    }

    public void setFocus() {
        this.dataView.setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                LastValues.this.dataView.refresh();
            }
        };
        this.actionAutoUpdate = new Action("Refresh &automatically", 2){

            public void run() {
                LastValues.this.dataView.setAutoRefreshEnabled(!LastValues.this.dataView.isAutoRefreshEnabled());
            }
        };
        this.actionAutoUpdate.setChecked(this.dataView.isAutoRefreshEnabled());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionAutoUpdate);
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }
}

