/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.internal.ZoomManager;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ZoomAction;

public class ExtendedGraphViewer
extends GraphViewer {
    private static final double[] zoomLevels = new double[]{0.1, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 2.5, 3.0, 4.0};
    private BackgroundFigure backgroundFigure;
    private Image backgroundImage = null;

    public ExtendedGraphViewer(Composite composite, int style) {
        super(composite, style);
        this.getZoomManager().setZoomLevels(zoomLevels);
        this.backgroundFigure = new BackgroundFigure();
        this.backgroundFigure.setSize(10, 10);
        this.getGraphControl().getRootLayer().add((IFigure)this.backgroundFigure, 0);
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
        if (image != null) {
            Rectangle r = image.getBounds();
            this.backgroundFigure.setSize(r.width, r.height);
        } else {
            this.backgroundFigure.setSize(10, 10);
        }
        this.getGraphControl().redraw();
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        if (this.getInput() == null) {
            return;
        }
        if (element == this.getInput()) {
            this.getFactory().refreshGraph(this.getGraphControl());
        } else {
            this.getFactory().refresh(this.getGraphControl(), element, updateLabels);
        }
    }

    public void zoomIn() {
        this.getZoomManager().zoomIn();
    }

    public void zoomOut() {
        this.getZoomManager().zoomOut();
    }

    public Action[] createZoomActions() {
        ZoomManager zoomManager = this.getZoomManager();
        Action[] actions = new Action[zoomLevels.length];
        int i = 0;
        while (i < zoomLevels.length) {
            actions[i] = new ZoomAction(zoomLevels[i], zoomManager);
            if (zoomLevels[i] == 1.0) {
                actions[i].setChecked(true);
            }
            ++i;
        }
        return actions;
    }

    private class BackgroundFigure
    extends Figure {
        private BackgroundFigure() {
        }

        protected void paintFigure(Graphics gc) {
            if (ExtendedGraphViewer.this.backgroundImage != null) {
                gc.drawImage(ExtendedGraphViewer.this.backgroundImage, 0, 0);
            }
        }
    }
}

