/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import java.util.UUID;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IFigureProvider;
import org.eclipse.zest.core.viewers.ISelfStyleProvider;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ConnectorLabel;
import org.netxms.ui.eclipse.networkmaps.views.helpers.DecorationFigure;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ObjectFigure;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class MapLabelProvider
extends LabelProvider
implements IFigureProvider,
ISelfStyleProvider {
    private NXCSession session;
    private GraphViewer viewer;
    private Image[] statusImages;
    private Image imgNodeGeneric;
    private Image imgNodeWindows;
    private Image imgNodeOSX;
    private Image imgNodeLinux;
    private Image imgNodeFreeBSD;
    private Image imgNodeSwitch;
    private Image imgNodeRouter;
    private Image imgNodePrinter;
    private Image imgSubnet;
    private Image imgService;
    private Image imgOther;
    private Image imgUnknown;
    private Font fontLabel;
    private Font fontTitle;
    private boolean showStatusIcons = true;
    private boolean showStatusBackground = false;
    private boolean showStatusFrame = false;

    public MapLabelProvider(GraphViewer viewer) {
        this.viewer = viewer;
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.statusImages = new Image[9];
        int i = 0;
        while (i < this.statusImages.length) {
            this.statusImages[i] = StatusDisplayInfo.getStatusImageDescriptor((int)i).createImage();
            ++i;
        }
        this.imgNodeGeneric = Activator.getImageDescriptor("icons/objects/macserver.png").createImage();
        this.imgNodeOSX = Activator.getImageDescriptor("icons/objects/macserver.png").createImage();
        this.imgNodeWindows = Activator.getImageDescriptor("icons/objects/windowsserver.png").createImage();
        this.imgNodeLinux = Activator.getImageDescriptor("icons/objects/linuxserver.png").createImage();
        this.imgNodeFreeBSD = Activator.getImageDescriptor("icons/objects/freebsdserver.png").createImage();
        this.imgNodeSwitch = Activator.getImageDescriptor("icons/objects/switch.png").createImage();
        this.imgNodeRouter = Activator.getImageDescriptor("icons/objects/router.png").createImage();
        this.imgNodePrinter = Activator.getImageDescriptor("icons/objects/printer.png").createImage();
        this.imgSubnet = Activator.getImageDescriptor("icons/objects/subnet.png").createImage();
        this.imgService = Activator.getImageDescriptor("icons/objects/service.png").createImage();
        this.imgOther = Activator.getImageDescriptor("icons/other.png").createImage();
        this.imgUnknown = Activator.getImageDescriptor("icons/objects/unknown.png").createImage();
        this.fontLabel = new Font((Device)Display.getDefault(), "Verdana", 7, 0);
        this.fontTitle = new Font((Device)Display.getDefault(), "Verdana", 10, 0);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.showStatusIcons = store.getBoolean("NetMap.ShowStatusIcon");
        this.showStatusFrame = store.getBoolean("NetMap.ShowStatusFrame");
        this.showStatusBackground = store.getBoolean("NetMap.ShowStatusBackground");
    }

    public String getText(Object element) {
        if (element instanceof NetworkMapObject) {
            GenericObject object = this.session.findObjectById(((NetworkMapObject)element).getObjectId());
            return object != null ? object.getObjectName() : null;
        }
        if (element instanceof NetworkMapLink) {
            return ((NetworkMapLink)element).getName();
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof NetworkMapObject) {
            GenericObject object = this.session.findObjectById(((NetworkMapObject)element).getObjectId());
            if (object != null) {
                UUID objectImageGuid = object.getImage();
                if (objectImageGuid != null && !objectImageGuid.equals(NXCommon.EMPTY_GUID)) {
                    return ImageProvider.getInstance().getImage(objectImageGuid);
                }
                switch (object.getObjectClass()) {
                    case 2: {
                        if ((((Node)object).getFlags() & 4) != 0) {
                            return this.imgNodeSwitch;
                        }
                        if ((((Node)object).getFlags() & 8) != 0) {
                            return this.imgNodeRouter;
                        }
                        if ((((Node)object).getFlags() & 0x20) != 0) {
                            return this.imgNodePrinter;
                        }
                        if (((Node)object).getPlatformName().startsWith("windows")) {
                            return this.imgNodeWindows;
                        }
                        if (((Node)object).getPlatformName().startsWith("Linux")) {
                            return this.imgNodeLinux;
                        }
                        if (((Node)object).getPlatformName().startsWith("FreeBSD")) {
                            return this.imgNodeFreeBSD;
                        }
                        return this.imgNodeGeneric;
                    }
                    case 1: {
                        return this.imgSubnet;
                    }
                    case 5: {
                        return this.imgService;
                    }
                }
                return this.imgOther;
            }
            return this.imgUnknown;
        }
        return null;
    }

    public IFigure getFigure(Object element) {
        if (element instanceof NetworkMapObject) {
            return new ObjectFigure((NetworkMapObject)element, this);
        }
        if (element instanceof NetworkMapDecoration) {
            return new DecorationFigure((NetworkMapDecoration)element, this);
        }
        return null;
    }

    public Image getStatusImage(GenericObject object) {
        Image image = null;
        try {
            image = this.statusImages[object.getStatus()];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return image;
    }

    public void dispose() {
        int i = 0;
        while (i < this.statusImages.length) {
            this.statusImages[i].dispose();
            ++i;
        }
        this.imgNodeGeneric.dispose();
        this.imgNodeWindows.dispose();
        this.imgNodeLinux.dispose();
        this.imgNodeOSX.dispose();
        this.imgNodeFreeBSD.dispose();
        this.imgNodeSwitch.dispose();
        this.imgNodeRouter.dispose();
        this.imgNodePrinter.dispose();
        this.imgSubnet.dispose();
        this.imgService.dispose();
        this.imgOther.dispose();
        this.imgUnknown.dispose();
        this.fontLabel.dispose();
        this.fontTitle.dispose();
        super.dispose();
    }

    public Font getLabelFont() {
        return this.fontLabel;
    }

    public Font getTitleFont() {
        return this.fontTitle;
    }

    public boolean isShowStatusIcons() {
        return this.showStatusIcons;
    }

    public void setShowStatusIcons(boolean showStatusIcons) {
        this.showStatusIcons = showStatusIcons;
    }

    public boolean isShowStatusBackground() {
        return this.showStatusBackground;
    }

    public void setShowStatusBackground(boolean showStatusBackground) {
        this.showStatusBackground = showStatusBackground;
    }

    public boolean isElementSelected(NetworkMapElement element) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection != null ? selection.toList().contains(element) : false;
    }

    public void selfStyleConnection(Object element, GraphConnection connection) {
        ConnectorLabel label;
        NetworkMapLink link = (NetworkMapLink)connection.getData();
        if (link.hasConnectorName1()) {
            ConnectionEndpointLocator sourceEndpointLocator = new ConnectionEndpointLocator(connection.getConnectionFigure(), false);
            sourceEndpointLocator.setVDistance(0);
            label = new ConnectorLabel(link.getConnectorName1());
            label.setFont(this.fontLabel);
            connection.getConnectionFigure().add((IFigure)label, (Object)sourceEndpointLocator);
        }
        if (link.hasConnectorName2()) {
            ConnectionEndpointLocator targetEndpointLocator = new ConnectionEndpointLocator(connection.getConnectionFigure(), true);
            targetEndpointLocator.setVDistance(0);
            label = new ConnectorLabel(link.getConnectorName2());
            label.setFont(this.fontLabel);
            connection.getConnectionFigure().add((IFigure)label, (Object)targetEndpointLocator);
        }
        connection.setLineWidth(2);
    }

    public void selfStyleNode(Object element, GraphNode node) {
        IFigure figure = node.getNodeFigure();
        if (figure != null && figure instanceof ObjectFigure) {
            ((ObjectFigure)figure).update();
            figure.repaint();
        }
    }

    public boolean isShowStatusFrame() {
        return this.showStatusFrame;
    }

    public void setShowStatusFrame(boolean showStatusFrame) {
        this.showStatusFrame = showStatusFrame;
    }
}

