/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.policymanager.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AgentPolicy;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DeployPolicy
implements IObjectActionDelegate {
    private Shell shell;
    private GenericObject currentObject;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        ObjectSelectionDialog dlg;
        long[] rootObjects = null;
        Object value = ConsoleSharedData.getProperty((String)"PolicyManager.rootObjects");
        if (value != null && value instanceof long[]) {
            rootObjects = (long[])value;
        }
        if ((dlg = new ObjectSelectionDialog(this.shell, rootObjects, ObjectSelectionDialog.createNodeSelectionFilter())).open() == 0) {
            new ConsoleJob("Deploy agent policy", null, "org.netxms.ui.eclipse.policymanager", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    NXCSession session = (NXCSession)ConsoleSharedData.getSession();
                    GenericObject[] nodeList = dlg.getSelectedObjects(2);
                    int i = 0;
                    while (i < nodeList.length) {
                        session.deployAgentPolicy(DeployPolicy.this.currentObject.getObjectId(), nodeList[i].getObjectId());
                        ++i;
                    }
                }

                protected String getErrorMessage() {
                    return "Cannot deploy agent policy";
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TreeSelection) {
            this.currentObject = (GenericObject)((TreeSelection)selection).getFirstElement();
            action.setEnabled(this.currentObject instanceof AgentPolicy);
        }
    }
}

