/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.Capabilities;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.Commands;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.Comments;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.Connection;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.GeneralInfo;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;

public class ObjectOverview
extends ObjectTab {
    private static final Color BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 255, 255, 255);
    private Set<OverviewPageElement> elements = new HashSet<OverviewPageElement>();
    private Composite viewArea;
    private Composite leftColumn;
    private Composite rightColumn;

    @Override
    protected void createTabContent(Composite parent) {
        this.viewArea = new Composite(parent, 0);
        this.viewArea.setBackground(BACKGROUND_COLOR);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.viewArea.setLayout((Layout)layout);
        this.leftColumn = new Composite(this.viewArea, 0);
        this.leftColumn.setLayout(this.createColumnLayout());
        this.leftColumn.setBackground(BACKGROUND_COLOR);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.leftColumn.setLayoutData((Object)gd);
        this.rightColumn = new Composite(this.viewArea, 0);
        this.rightColumn.setLayout(this.createColumnLayout());
        this.rightColumn.setBackground(BACKGROUND_COLOR);
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = -1;
        this.rightColumn.setLayoutData((Object)gd);
        this.addElement(new GeneralInfo(this.leftColumn, this.getObject()));
        this.addElement(new Commands(this.leftColumn, this.getObject()));
        this.addElement(new Comments(this.leftColumn, this.getObject()));
        this.addElement(new Capabilities(this.rightColumn, this.getObject()));
        this.addElement(new Connection(this.rightColumn, this.getObject()));
    }

    private Layout createColumnLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        return layout;
    }

    private void addElement(OverviewPageElement element) {
        GridData gd = new GridData();
        gd.exclude = false;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        element.setLayoutData(gd);
        this.elements.add(element);
    }

    @Override
    public void objectChanged(GenericObject object) {
        this.viewArea.setRedraw(false);
        for (OverviewPageElement element : this.elements) {
            element.setVisible(element.isApplicableForObject(object));
            ((GridData)element.getLayoutData()).exclude = !element.isVisible();
            element.setObject(object);
        }
        this.viewArea.layout(true, true);
        this.viewArea.setRedraw(true);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void selected() {
        this.objectChanged(this.getObject());
    }

    @Override
    public void refresh() {
        this.objectChanged(this.getObject());
    }
}

