/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.views.HostSearchResults;

public class FindConnectionPoint
implements IObjectActionDelegate {
    private IWorkbenchPart wbPart;
    private long objectId;

    public void run(IAction action) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Find connection point for object " + this.objectId, this.wbPart, "org.netxms.ui.eclipse.topology", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final ConnectionPoint cp = session.findConnectionPoint(FindConnectionPoint.this.objectId);
                new UIJob("Show connection point"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        HostSearchResults.showConnection(cp);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            protected String getErrorMessage() {
                return "Cannot get conection point information";
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof Node || obj instanceof Interface) {
                action.setEnabled(true);
                this.objectId = ((GenericObject)obj).getObjectId();
            } else {
                action.setEnabled(false);
                this.objectId = 0L;
            }
        } else {
            action.setEnabled(false);
            this.objectId = 0L;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.wbPart = targetPart;
    }
}

