/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.dialogs.EnterMacAddressDlg;
import org.netxms.ui.eclipse.topology.views.HostSearchResults;

public class FindMacAddress
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void run(IAction action) {
        EnterMacAddressDlg dlg = new EnterMacAddressDlg(this.window.getShell());
        if (dlg.open() != 0) {
            return;
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final MacAddress macAddr = dlg.getMacAddress();
        new ConsoleJob("Searching for MAC address " + macAddr + " in the network", null, "org.netxms.ui.eclipse.topology", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final ConnectionPoint cp = session.findConnectionPoint(macAddr);
                new UIJob("Show connection point"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        HostSearchResults.showConnection(cp);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            protected String getErrorMessage() {
                return "Search for MAC address " + macAddr + " failed";
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

