/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.topology.Port;
import org.netxms.client.topology.VlanInfo;

public class VlanLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        VlanInfo vlan = (VlanInfo)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(vlan.getVlanId());
            }
            case 1: {
                return vlan.getName();
            }
            case 2: {
                return this.buildPortList(vlan);
            }
        }
        return null;
    }

    private String buildPortList(VlanInfo vlan) {
        int lastPort;
        Port[] ports = vlan.getPorts();
        if (ports.length == 0) {
            return "";
        }
        int slot = ports[0].getSlot();
        int firstPort = lastPort = ports[0].getPort();
        StringBuilder sb = new StringBuilder();
        sb.append(slot);
        sb.append('/');
        sb.append(firstPort);
        int i = 1;
        while (i < ports.length) {
            if (ports[i].getSlot() == slot && ports[i].getPort() == lastPort + 1) {
                ++lastPort;
            } else {
                if (ports[i - 1].getPort() != firstPort) {
                    if (lastPort - firstPort > 1) {
                        sb.append('-');
                    } else {
                        sb.append(',');
                    }
                    sb.append(slot);
                    sb.append('/');
                    sb.append(lastPort);
                }
                slot = ports[i].getSlot();
                firstPort = lastPort = ports[i].getPort();
                sb.append(',');
                sb.append(slot);
                sb.append('/');
                sb.append(lastPort);
            }
            ++i;
        }
        if (ports[i - 1].getPort() != firstPort) {
            if (lastPort - firstPort > 1) {
                sb.append('-');
            } else {
                sb.append(',');
            }
            sb.append(slot);
            sb.append('/');
            sb.append(lastPort);
        }
        return sb.toString();
    }
}

