/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.imagelibrary.widgets.ImageSelector;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class General
extends PropertyPage {
    private Text textName;
    private String initialName;
    private GenericObject object;
    private ImageSelector image;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (GenericObject)this.getElement().getAdapter(GenericObject.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        WidgetHelper.createLabeledText((Composite)dialogArea, (int)2060, (int)-1, (String)"Object ID", (String)Long.toString(this.object.getObjectId()), (Object)"WidgetHelper::default_layout_data");
        WidgetHelper.createLabeledText((Composite)dialogArea, (int)2060, (int)-1, (String)"Object class", (String)this.object.getObjectClassName(), (Object)"WidgetHelper::default_layout_data");
        this.initialName = new String(this.object.getObjectName());
        this.textName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)"Object name", (String)this.initialName, (Object)"WidgetHelper::default_layout_data");
        this.image = new ImageSelector(dialogArea, 0);
        this.image.setLabel("Presentation image");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.image.setLayoutData((Object)gd);
        this.image.setImageGuid(this.object.getImage(), false);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final String newName = new String(this.textName.getText());
        final UUID newImage = this.image.getImageGuid();
        new ConsoleJob("Rename object", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NXCObjectModificationData data = new NXCObjectModificationData(General.this.object.getObjectId());
                data.setName(newName);
                data.setImage(newImage);
                ((NXCSession)ConsoleSharedData.getSession()).modifyObject(data);
                General.this.initialName = newName;
            }

            protected String getErrorMessage() {
                return "Cannot modify object";
            }

            protected void jobFinalize() {
                if (isApply) {
                    new UIJob("Update \"General\" property page"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            General.this.setValid(true);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        }.schedule();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

