/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.dialogs;

import java.util.Collection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogColumn;

public class ColumnSelectionDialog
extends Dialog {
    private Log logHandle;
    private Combo columnList;
    private LogColumn[] columns;
    private LogColumn selectedColumn;

    public ColumnSelectionDialog(Shell parentShell, Log logHandle) {
        super(parentShell);
        this.logHandle = logHandle;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText("Log columns");
        this.columnList = new Combo(dialogArea, 12);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 250;
        this.columnList.setLayoutData((Object)gd);
        Collection c = this.logHandle.getColumns();
        this.columns = c.toArray(new LogColumn[c.size()]);
        int i = 0;
        while (i < this.columns.length) {
            this.columnList.add(this.columns[i].getDescription());
            ++i;
        }
        this.columnList.setFocus();
        return dialogArea;
    }

    protected void okPressed() {
        int index = this.columnList.getSelectionIndex();
        if (index >= 0) {
            this.selectedColumn = this.columns[index];
            super.okPressed();
        } else {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"You should select column first!");
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Column");
    }

    public LogColumn getSelectedColumn() {
        return this.selectedColumn;
    }
}

