/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.dashboards.DashboardElement;

public class DashboardElementsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String[] ELEMENT_TYPES = new String[]{"Label", "Line Chart", "Bar Chart", "Pie Chart", "Status Indicator"};
    private static final String[] H_ALIGH = new String[]{"FILL", "CENTER", "LEFT", "RIGHT"};
    private static final String[] V_ALIGH = new String[]{"FILL", "CENTER", "TOP", "BOTTOM"};

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DashboardElement de = (DashboardElement)element;
        switch (columnIndex) {
            case 0: {
                try {
                    return ELEMENT_TYPES[de.getType()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return "<unknown>";
                }
            }
            case 1: {
                return String.valueOf(Integer.toString(de.getHorizontalSpan())) + " / " + Integer.toString(de.getVerticalSpan());
            }
            case 2: {
                try {
                    return String.valueOf(H_ALIGH[de.getHorizontalAlignment()]) + " / " + V_ALIGH[de.getVerticalAlignment()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return "<unknown>";
                }
            }
        }
        return null;
    }
}

