/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciData;
import org.netxms.ui.eclipse.charts.widgets.DataComparisonBirtChart;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardDciInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public abstract class ComparisionChartElement
extends ElementWidget {
    protected DataComparisonBirtChart chart;
    protected NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private Runnable refreshTimer;
    private boolean updateInProgress = false;

    public ComparisionChartElement(Composite parent, String data) {
        super(parent, data);
        this.setLayout((Layout)new FillLayout());
    }

    protected void startRefreshTimer() {
        final Display display = this.getDisplay();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (ComparisionChartElement.this.isDisposed()) {
                    return;
                }
                ComparisionChartElement.this.refreshData(ComparisionChartElement.this.getDciList());
                display.timerExec(30000, (Runnable)this);
            }
        };
        display.timerExec(30000, this.refreshTimer);
        this.refreshData(this.getDciList());
    }

    protected void refreshData(final DashboardDciInfo[] dciList) {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        ConsoleJob job = new ConsoleJob("Get DCI values for history graph", null, "org.netxms.ui.eclipse.dashboard", "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < dciList.length) {
                    final DciData data = ComparisionChartElement.this.session.getCollectedData(dciList[i].nodeId, dciList[i].dciId, null, null, 1);
                    final int index = i++;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).ComparisionChartElement.this.chart.isDisposed()) {
                                (this).ComparisionChartElement.this.chart.updateParameter(index, data.getLastValue().getValueAsDouble(), false);
                            }
                        }
                    });
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).ComparisionChartElement.this.chart.refresh();
                        ComparisionChartElement.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get DCI values for comparision chart";
            }

            protected void jobFailureHandler() {
                ComparisionChartElement.this.updateInProgress = false;
                super.jobFailureHandler();
            }
        };
        job.setUser(false);
        job.start();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (hHint == -1 && size.y < 250) {
            size.y = 250;
        }
        return size;
    }

    protected abstract DashboardDciInfo[] getDciList();
}

