/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.dashboard.widgets.BarChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.LabelElement;
import org.netxms.ui.eclipse.dashboard.widgets.LineChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.PieChartElement;

public class DashboardControl
extends Composite {
    private Dashboard dashboard;

    public DashboardControl(Composite parent, int style, Dashboard dashboard) {
        super(parent, style);
        this.dashboard = dashboard;
        this.setBackground(new Color((Device)this.getDisplay(), 255, 255, 255));
        this.createContent();
    }

    private void createContent() {
        GridLayout layout = new GridLayout();
        layout.numColumns = this.dashboard.getNumColumns();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        this.setLayout((Layout)layout);
        for (DashboardElement e : this.dashboard.getElements()) {
            ElementWidget w = this.createElementWidget(e);
            GridData gd = new GridData();
            int he = e.getHorizontalAlignment();
            gd.grabExcessHorizontalSpace = he == 0;
            gd.horizontalAlignment = DashboardControl.mapHorizontalAlignment(e.getHorizontalAlignment());
            gd.grabExcessVerticalSpace = e.getVerticalAlignment() == 0;
            gd.verticalAlignment = DashboardControl.mapVerticalAlignment(e.getVerticalAlignment());
            gd.horizontalSpan = e.getHorizontalSpan();
            gd.verticalSpan = e.getVerticalSpan();
            w.setLayoutData(gd);
        }
    }

    static int mapHorizontalAlignment(int a) {
        switch (a) {
            case 0: {
                return 4;
            }
            case 2: {
                return 16384;
            }
            case 3: {
                return 131072;
            }
            case 1: {
                return 0x1000000;
            }
        }
        return 0;
    }

    static int mapVerticalAlignment(int a) {
        switch (a) {
            case 0: {
                return 4;
            }
            case 2: {
                return 128;
            }
            case 3: {
                return 1024;
            }
            case 1: {
                return 0x1000000;
            }
        }
        return 0;
    }

    private ElementWidget createElementWidget(DashboardElement e) {
        switch (e.getType()) {
            case 1: {
                return new LineChartElement(this, e.getData());
            }
            case 2: {
                return new BarChartElement(this, e.getData());
            }
            case 3: {
                return new PieChartElement(this, e.getData());
            }
            case 0: {
                return new LabelElement(this, e.getData());
            }
        }
        return new ElementWidget(this, e.getData());
    }
}

