/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.views;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.osm.tools.MapAccessor;
import org.netxms.ui.eclipse.osm.widgets.GeoMapViewer;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class LocationMap
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.osm.views.LocationMap";
    public static final String JOB_FAMILY = "MapViewJob";
    private GeoMapViewer map;
    private MapAccessor mapAccessor;
    private GenericObject object;
    private int zoomLevel = 15;
    private Action actionZoomIn;
    private Action actionZoomOut;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            Platform.getAdapterManager().loadAdapter((Object)((NXCSession)ConsoleSharedData.getSession()).getTopLevelObjects()[0], "org.eclipse.ui.model.IWorkbenchAdapter");
        }
        catch (Exception exception) {}
        try {
            long id = Long.parseLong(site.getSecondaryId());
            this.object = ((NXCSession)ConsoleSharedData.getSession()).findObjectById(id);
            this.setPartName("Geolocation - " + this.object.getObjectName());
        }
        catch (Exception e) {
            throw new PartInitException("Cannot initialize geolocation view: internal error", (Throwable)e);
        }
        if (this.object == null) {
            throw new PartInitException("Cannot initialize geolocation view: object not found");
        }
    }

    public void createPartControl(Composite parent) {
        this.map = new GeoMapViewer(parent, 2048);
        this.map.setSiteService((IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class));
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.mapAccessor = new MapAccessor(this.object.getGeolocation());
        this.mapAccessor.setZoom(this.zoomLevel);
        this.map.showMap(this.mapAccessor);
        this.map.setCenterMarker(this.object);
    }

    private void createActions() {
        this.actionZoomIn = new Action("Zoom &in"){

            public void run() {
                LocationMap.this.setZoomLevel(LocationMap.this.zoomLevel + 1);
            }
        };
        this.actionZoomIn.setImageDescriptor(SharedIcons.ZOOM_IN);
        this.actionZoomOut = new Action("Zoom &out"){

            public void run() {
                LocationMap.this.setZoomLevel(LocationMap.this.zoomLevel - 1);
            }
        };
        this.actionZoomOut.setImageDescriptor(SharedIcons.ZOOM_OUT);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                LocationMap.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.map);
        this.map.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
    }

    public void setFocus() {
        this.map.setFocus();
    }

    private void setZoomLevel(int newLevel) {
        if (newLevel < 0 || newLevel > 18) {
            return;
        }
        this.zoomLevel = newLevel;
        this.mapAccessor.setZoom(this.zoomLevel);
        this.map.showMap(this.mapAccessor);
        this.actionZoomIn.setEnabled(this.zoomLevel < 18);
        this.actionZoomOut.setEnabled(this.zoomLevel > 0);
    }

    public void dispose() {
        super.dispose();
    }
}

