/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AlarmComparator
extends ViewerComparator {
    private int compareNumbers(long n1, long n2) {
        return n1 < n2 ? -1 : (n1 > n2 ? 1 : 0);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int rc;
        TableColumn sortColumn = ((TableViewer)viewer).getTable().getSortColumn();
        if (sortColumn == null) {
            return 0;
        }
        switch ((Integer)sortColumn.getData("ID")) {
            case 0: {
                rc = this.compareNumbers(((Alarm)e1).getCurrentSeverity(), ((Alarm)e2).getCurrentSeverity());
                break;
            }
            case 1: {
                rc = this.compareNumbers(((Alarm)e1).getState(), ((Alarm)e2).getState());
                break;
            }
            case 2: {
                GenericObject obj1 = ((NXCSession)ConsoleSharedData.getSession()).findObjectById(((Alarm)e1).getSourceObjectId());
                GenericObject obj2 = ((NXCSession)ConsoleSharedData.getSession()).findObjectById(((Alarm)e2).getSourceObjectId());
                String name1 = obj1 != null ? obj1.getObjectName() : "<unknown>";
                String name2 = obj2 != null ? obj2.getObjectName() : "<unknown>";
                rc = name1.compareToIgnoreCase(name2);
                break;
            }
            case 3: {
                rc = ((Alarm)e1).getMessage().compareToIgnoreCase(((Alarm)e2).getMessage());
                break;
            }
            case 4: {
                rc = this.compareNumbers(((Alarm)e1).getRepeatCount(), ((Alarm)e2).getRepeatCount());
                break;
            }
            case 5: {
                rc = ((Alarm)e1).getCreationTime().compareTo(((Alarm)e2).getCreationTime());
                break;
            }
            case 6: {
                rc = ((Alarm)e1).getLastChangeTime().compareTo(((Alarm)e2).getLastChangeTime());
                break;
            }
            default: {
                rc = 0;
            }
        }
        int dir = ((TableViewer)viewer).getTable().getSortDirection();
        return dir == 128 ? rc : -rc;
    }
}

