/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.ui.eclipse.snmp.Activator;
import org.netxms.ui.eclipse.snmp.widgets.MibBrowser;
import org.netxms.ui.eclipse.snmp.widgets.MibObjectDetails;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class MibSelectionDialog
extends Dialog {
    private MibBrowser mibTree;
    private Text oid;
    private MibObjectDetails details;
    private MibObject selectedObject;
    private SnmpObjectId initialSelection;
    private boolean updateObjectId = true;

    public MibSelectionDialog(Shell parentShell, SnmpObjectId initialSelection) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.initialSelection = initialSelection;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select MIB Object");
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("MibSelectionDialog.cx"), settings.getInt("MibSelectionDialog.cy"));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected Control createDialogArea(Composite parent) {
        MibObject object;
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.oid = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)500, (String)"Object identifier (OID)", (String)"", (Object)"WidgetHelper::default_layout_data");
        this.oid.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MibSelectionDialog.this.onManualOidChange();
            }
        });
        Composite mibTreeGroup = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        mibTreeGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        mibTreeGroup.setLayoutData((Object)gd);
        Label label = new Label(mibTreeGroup, 0);
        label.setText("MIB tree");
        this.mibTree = new MibBrowser(mibTreeGroup, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.widthHint = 500;
        gd.heightHint = 250;
        this.mibTree.setLayoutData(gd);
        this.mibTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MibSelectionDialog.this.onMibTreeSelectionChanged();
            }
        });
        this.details = new MibObjectDetails(dialogArea, 0, false, this.mibTree);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.details.setLayoutData(gd);
        if (this.initialSelection != null && (object = Activator.getMibTree().findObject(this.initialSelection, false)) != null) {
            this.mibTree.setSelection(object);
        }
        return dialogArea;
    }

    private void onMibTreeSelectionChanged() {
        MibObject object = this.mibTree.getSelection();
        if (object != null && this.updateObjectId) {
            SnmpObjectId objectId = object.getObjectId();
            this.oid.setText(objectId != null ? objectId.toString() : "");
        }
        this.details.setObject(object);
    }

    protected void okPressed() {
        this.selectedObject = this.mibTree.getSelection();
        if (this.selectedObject == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select MIB object before pressing OK");
            return;
        }
        this.saveSettings();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("MibSelectionDialog.cx", size.x);
        settings.put("MibSelectionDialog.cy", size.y);
    }

    public MibObject getSelectedObject() {
        return this.selectedObject;
    }

    private void onManualOidChange() {
        try {
            SnmpObjectId id = SnmpObjectId.parseSnmpObjectId((String)this.oid.getText());
            MibObject o = Activator.getMibTree().findObject(id, false);
            if (o != null) {
                this.updateObjectId = false;
                this.mibTree.setSelection(o);
                this.updateObjectId = true;
            }
        }
        catch (SnmpObjectIdFormatException snmpObjectIdFormatException) {}
    }
}

